/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.network.VisualUpdateMessage;

public class VisualUpdateTracker {
    private static final Map<ResourceKey<Level>, Map<ChunkPos, Set<BlockPos>>> UPDATES = new HashMap<ResourceKey<Level>, Map<ChunkPos, Set<BlockPos>>>();

    public static void sendVisualUpdate(EBlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (level != null && !level.isClientSide) {
            Map chunkUpdates = UPDATES.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> new HashMap());
            chunkUpdates.computeIfAbsent(new ChunkPos(blockEntity.getBlockPos()), key -> new HashSet()).add(blockEntity.getBlockPos());
        }
    }

    public static void syncVisualUpdates(MinecraftServer server) {
        for (Map.Entry<ResourceKey<Level>, Map<ChunkPos, Set<BlockPos>>> levelUpdates : UPDATES.entrySet()) {
            ServerLevel level = server.getLevel(levelUpdates.getKey());
            if (level == null) continue;
            Map<ChunkPos, Set<BlockPos>> pendingUpdates = levelUpdates.getValue();
            for (Map.Entry<ChunkPos, Set<BlockPos>> chunkUpdates : pendingUpdates.entrySet()) {
                ChunkPos chunkPos = chunkUpdates.getKey();
                for (BlockPos updatePos : chunkUpdates.getValue()) {
                    BlockEntity blockEntity = level.getBlockEntity(updatePos);
                    if (!(blockEntity instanceof EBlockEntity)) continue;
                    EBlockEntity blockEntity2 = (EBlockEntity)blockEntity;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new VisualUpdateMessage(updatePos, blockEntity2, blockEntity2.getType(), null), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            pendingUpdates.clear();
        }
    }
}

