/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;

public class WeightedList<T> {
    private static final WeightedList<Object> EMPTY = new WeightedList(0, new Object[0], new int[0]);
    private final int totalWeight;
    private final Object[] values;
    private final int[] weights;

    private WeightedList(int totalWeight, Object[] values, int[] weights) {
        Preconditions.checkArgument((values.length == weights.length ? 1 : 0) != 0, (Object)"Values and weights arrays are different sizes");
        this.totalWeight = totalWeight;
        this.values = values;
        this.weights = weights;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public T getRandom(RandomSource rand) {
        int chosenIndex = rand.nextInt(this.totalWeight);
        for (int i = 0; i < this.values.length; ++i) {
            if ((chosenIndex -= this.weights[i]) >= 0) continue;
            return (T)this.values[i];
        }
        throw new IllegalStateException("Could not get random element");
    }

    public void toNetwork(FriendlyByteBuf buffer, BiConsumer<FriendlyByteBuf, T> valueWriter) {
        buffer.writeVarInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            valueWriter.accept(buffer, (FriendlyByteBuf)this.values[i]);
            buffer.writeVarInt(this.weights[i]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedList that = (WeightedList)o;
        return Arrays.equals(this.values, that.values) && Arrays.equals(this.weights, that.weights);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.values);
        result = 31 * result + Arrays.hashCode(this.weights);
        return result;
    }

    public static <T> WeightedList<T> fromNetwork(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> valueReader) {
        int size = buffer.readVarInt();
        Object[] values = new Object[size];
        int[] weights = new int[size];
        int totalWeight = 0;
        for (int i = 0; i < size; ++i) {
            values[i] = Objects.requireNonNull(valueReader.apply(buffer), "Failed to read weighted list value from network");
            weights[i] = buffer.readVarInt();
            totalWeight += weights[i];
        }
        return new WeightedList<T>(totalWeight, values, weights);
    }

    public static <T> Codec<WeightedList<T>> codec(Codec<T> valueCodec) {
        return Entry.codec(valueCodec).listOf().xmap(entries -> {
            Builder builder = WeightedList.builder();
            for (Entry entry : entries) {
                builder.add(entry.weight, entry.value);
            }
            return builder.build();
        }, list -> {
            Object[] entries = new Entry[list.values.length];
            ObjectImmutableList entryList = new ObjectImmutableList(entries);
            for (int i = 0; i < list.values.length; ++i) {
                entries[i] = new Entry<Object>(list.values[i], list.weights[i]);
            }
            return entryList;
        });
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> WeightedList<T> empty() {
        return EMPTY;
    }

    private record Entry<T>(T value, int weight) {
        private static <T> Codec<Entry<T>> codec(Codec<T> valueCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)valueCodec.fieldOf("value").forGetter(Entry::value), (App)Codec.INT.fieldOf("weight").forGetter(Entry::weight)).apply((Applicative)instance, Entry::new));
        }
    }

    public static class Builder<T> {
        private final ArrayList<T> values = new ArrayList();
        private final IntArrayList weights = new IntArrayList();
        private int totalWeight;

        public Builder<T> add(int weight, T element) {
            this.totalWeight += weight;
            this.values.add(element);
            this.weights.add(weight);
            return this;
        }

        public WeightedList<T> build() {
            return new WeightedList(this.totalWeight, this.values.toArray(), this.weights.toArray(new int[0]));
        }
    }
}

