/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.tag;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.neoforge.registries.DeferredHolder;
import thedarkcolour.exdeorum.ExDeorum;

public class EBiomeTags {
    public static final Map<TagKey<Biome>, DeferredHolder<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>>> TREE_TAGS = new HashMap();

    private static void addTreeTag(String tagName, ResourceLocation id) {
        TagKey<Biome> tag = EBiomeTags.tag(tagName);
        if (TREE_TAGS.put(tag, DeferredHolder.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)id)) != null) {
            throw new IllegalStateException("Already added a tree tag under " + String.valueOf(tag));
        }
    }

    private static TagKey<Biome> tag(String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ExDeorum.loc(name));
    }

    static {
        EBiomeTags.addTreeTag("oak_tree_biomes", TreeFeatures.OAK_BEES_005.location());
        EBiomeTags.addTreeTag("spruce_tree_biomes", TreeFeatures.SPRUCE.location());
        EBiomeTags.addTreeTag("birch_tree_biomes", TreeFeatures.BIRCH_BEES_002.location());
        EBiomeTags.addTreeTag("jungle_tree_biomes", TreeFeatures.JUNGLE_TREE_NO_VINE.location());
        EBiomeTags.addTreeTag("acacia_tree_biomes", TreeFeatures.ACACIA.location());
        EBiomeTags.addTreeTag("cherry_tree_biomes", TreeFeatures.CHERRY_BEES_005.location());
        EBiomeTags.addTreeTag("dark_oak_tree_biomes", TreeFeatures.DARK_OAK.location());
        EBiomeTags.addTreeTag("mangrove_tree_biomes", TreeFeatures.MANGROVE.location());
        EBiomeTags.addTreeTag("flowering_oak_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"flowering_oak_tree_bees"));
        EBiomeTags.addTreeTag("mahogany_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"mahogany_tree"));
        EBiomeTags.addTreeTag("jacaranda_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"jacaranda_tree_bees"));
        EBiomeTags.addTreeTag("palm_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"palm_tree"));
        EBiomeTags.addTreeTag("willow_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"willow_tree"));
        EBiomeTags.addTreeTag("dead_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"dead_tree_wasteland"));
        EBiomeTags.addTreeTag("magic_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"magic_tree"));
        EBiomeTags.addTreeTag("umbran_tree_biomes", ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)"umbran_tree"));
    }
}

