/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.volumes;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.multiblock.CuboidDescriptor;
import tv.soaryn.xycraft.world.content.registries.WorldAttachments;
import tv.soaryn.xycraft.world.content.volumes.AtmosphereVolumeCache;

@EventBusSubscriber(modid="xycraft_world", bus=EventBusSubscriber.Bus.GAME)
public interface Atmosphere {
    public static Stream<AtmosphereVolumeCache.AtmosphereVolume> of(ServerLevel level, BlockPos pos) {
        return FastVolumeLookup.of((Level)level, AtmosphereVolumeCache.AtmosphereVolume.class).find(pos);
    }

    public static void add(Level level, BlockPos pos, CuboidDescriptor descriptor) {
        AtmosphereVolumeCache cache = (AtmosphereVolumeCache)level.getData(WorldAttachments.AtmosphereVolumeData);
        if (cache.map().containsKey((Object)pos)) {
            Atmosphere.remove(level, pos);
        }
        AtmosphereVolumeCache.AtmosphereVolume atmosphere = new AtmosphereVolumeCache.AtmosphereVolume(pos, descriptor);
        cache.map().put((Object)pos, (Object)atmosphere);
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, AtmosphereVolumeCache.AtmosphereVolume.class);
        lookup.add((Object)atmosphere, descriptor.min(), descriptor.max());
    }

    public static void remove(Level level, BlockPos pos) {
        AtmosphereVolumeCache cache = (AtmosphereVolumeCache)level.getData(WorldAttachments.AtmosphereVolumeData);
        if (!cache.map().containsKey((Object)pos)) {
            return;
        }
        AtmosphereVolumeCache.AtmosphereVolume removedValue = (AtmosphereVolumeCache.AtmosphereVolume)cache.map().remove((Object)pos);
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, AtmosphereVolumeCache.AtmosphereVolume.class);
        lookup.remove((Object)removedValue);
    }

    @SubscribeEvent
    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        AtmosphereVolumeCache cache = (AtmosphereVolumeCache)serverLevel.getData(WorldAttachments.AtmosphereVolumeData);
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)serverLevel, AtmosphereVolumeCache.AtmosphereVolume.class);
        cache.map().forEach((pos, atmosphereVolume) -> lookup.add(atmosphereVolume, atmosphereVolume.descriptor().min(), atmosphereVolume.descriptor().max()));
    }
}

