/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.datagen;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.Tag;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.core.utils.IngredientUtils;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class WorldRecipeDataGen
extends RecipeProvider {
    public WorldRecipeDataGen(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    protected void buildRecipes(@NotNull RecipeOutput finished) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((TagKey)XyCraftTags.Items.AluminumRaw.tag()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)WorldContent.Item.AluminumIngot.item(), (float)0.7f, (int)200).unlockedBy("has_raw_aluminum", WorldRecipeDataGen.has((ItemLike)WorldContent.Item.AluminumIngot.item())).save(finished, "xycraft:smelting/aluminum");
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((TagKey)XyCraftTags.Items.AluminumRaw.tag()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)WorldContent.Item.AluminumIngot.item(), (float)0.7f, (int)100).unlockedBy("has_raw_aluminum", WorldRecipeDataGen.has((ItemLike)WorldContent.Item.AluminumIngot.item())).save(finished, "xycraft:blasting/aluminum");
        this.buildCompactingRecipe(finished, (ItemLike)WorldContent.Block.AluminumStorage.block(), (ItemLike)WorldContent.Item.AluminumIngot.item(), (TagKey<Item>)XyCraftTags.Items.AluminumIngot.tag());
        this.buildCompactingRecipe(finished, (ItemLike)WorldContent.Item.AluminumIngot.item(), (ItemLike)WorldContent.Item.AluminumNugget.item(), (TagKey<Item>)XyCraftTags.Items.AluminumNugget.tag());
        this.buildCompactingRecipe(finished, (ItemLike)WorldContent.Block.RawAluminumBlock.block(), (ItemLike)WorldContent.Item.RawAluminum.item(), (TagKey<Item>)XyCraftTags.Items.AluminumRaw.tag());
        WorldContent.Block.XychoriumStorage.forEach((customColors, blockContent) -> this.buildCompactingRecipe(finished, (ItemLike)blockContent, (ItemLike)WorldContent.Item.XychoriumGem.get(customColors).item(), IngredientUtils.withColor((Tag)XyCraftTags.Items.XychoriumGem, (XyCraftColors)customColors), (TagKey<Item>)XyCraftTags.Items.AluminumRaw.tag()));
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.Lamp.tag(), (ItemLike)WorldContent.Block.LampPillar.get(DyeColors.White).block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.Lamp.tag(), (ItemLike)WorldContent.Block.LampCube.get(DyeColors.White).block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.Lamp.tag(), (ItemLike)WorldContent.Block.LampFlush.get(DyeColors.White).block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.Lamp.tag(), (ItemLike)WorldContent.Block.LampLantern.get(DyeColors.White).block());
        this.buildStoneCutting(finished, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_CHEAP, (ItemLike)Blocks.GLASS);
        this.buildStoneCutting(finished, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_TINTED, (ItemLike)Blocks.TINTED_GLASS);
        this.buildStoneCutting(finished, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_CHEAP, (ItemLike)WorldContent.Block.GlassViewer.block());
        this.buildStoneCutting(finished, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_CHEAP, (ItemLike)WorldContent.Block.GlassViewerDire.block());
        this.buildStoneCutting(finished, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_CHEAP, (ItemLike)WorldContent.Block.GlassViewerSilicon.block());
        this.buildStoneCutting(finished, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_TINTED, (ItemLike)WorldContent.Block.GlassViewerDark.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.KiviItemBlock.tag(), (ItemLike)WorldContent.Block.Kivi.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.KiviItemBlock.tag(), (ItemLike)WorldContent.Block.KiviRajan.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.KiviItemBlock.tag(), (ItemLike)WorldContent.Block.KiviBricks.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.KiviItemBlock.tag(), (ItemLike)WorldContent.Block.KiviTiles.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.KiviItemBlock.tag(), (ItemLike)WorldContent.Block.SmoothKivi.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.GlassGlowing.tag(), (ItemLike)WorldContent.Block.GlassViewerGlowing.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.GlassGlowing.tag(), (ItemLike)WorldContent.Block.GlassViewerGlowingClear.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.AluminumItemBlock.tag(), (ItemLike)WorldContent.Block.AluminumBricks.block());
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.AluminumItemBlock.tag(), (ItemLike)WorldContent.Block.AluminumTiles.block());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AluminumBricks.block(), (int)4).define(Character.valueOf('1'), XyCraftTags.Items.AluminumIngot.tag()).pattern("11").pattern("11").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/aluminum_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AluminumTiles.block(), (int)4).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.AluminumBricks.block()).pattern("11").pattern("11").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/aluminum_tiles");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.KiviBricks.block(), (int)4).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.Kivi.block()).pattern("11").pattern("11").unlockedBy("has_kivi", WorldRecipeDataGen.has((ItemLike)WorldContent.Block.Kivi.block())).save(finished, "xycraft:shaped/kivi_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.KiviTiles.block(), (int)4).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.KiviBricks.block()).pattern("11").pattern("11").unlockedBy("has_kivi_bricks", WorldRecipeDataGen.has((ItemLike)WorldContent.Block.KiviBricks.block())).save(finished, "xycraft:shaped/kivi_tiles");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerGlowing.block(), (int)8).define(Character.valueOf('1'), Tags.Items.GLASS_BLOCKS_CHEAP).define(Character.valueOf('2'), (ItemLike)Items.GLOW_INK_SAC).pattern("111").pattern("121").pattern("111").unlockedBy("has_glow_ink", WorldRecipeDataGen.has((ItemLike)Items.GLOW_INK_SAC)).save(finished, "xycraft:shaped/glass_viewer_glowing_glow");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerGlowing.block()).requires(Tags.Items.DUSTS_GLOWSTONE).requires(Tags.Items.GLASS_BLOCKS_CHEAP).unlockedBy("has_glowstone_dust", WorldRecipeDataGen.has((TagKey)Tags.Items.DUSTS_GLOWSTONE)).save(finished, "xycraft:shapeless/glass_viewer_glowing_dust");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerReinforced.block(), (int)2).define(Character.valueOf('1'), Tags.Items.INGOTS_IRON).define(Character.valueOf('2'), Tags.Items.GLASS_BLOCKS_CHEAP).pattern("12").pattern("21").unlockedBy("has_iron_ingot", WorldRecipeDataGen.has((TagKey)Tags.Items.INGOTS_IRON)).save(finished, "xycraft:shaped/glass_viewer_reinforced");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerImmortal.block()).define(Character.valueOf('1'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('2'), Tags.Items.OBSIDIANS).define(Character.valueOf('3'), (ItemLike)WorldContent.Block.GlassViewerReinforced.block()).pattern("121").pattern("232").pattern("121").unlockedBy("has_aluminum_ingot", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/glass_viewer_immortal");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerImmortal.block()).define(Character.valueOf('2'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('1'), Tags.Items.OBSIDIANS).define(Character.valueOf('3'), (ItemLike)WorldContent.Block.GlassViewerReinforced.block()).pattern("121").pattern("232").pattern("121").unlockedBy("has_aluminum_ingot", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/glass_viewer_immortal_r");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerPhantom.block(), (int)8).define(Character.valueOf('1'), DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS_CHEAP), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{WorldContent.Block.GlassViewerPhantom.block()}))).define(Character.valueOf('2'), (ItemLike)Items.CHORUS_FRUIT).pattern("111").pattern("121").pattern("111").unlockedBy("has_chorus", WorldRecipeDataGen.has((ItemLike)Items.CHORUS_FRUIT)).save(finished, "xycraft:shaped/glass_viewer_phantom_chorus");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerPhantom.block(), (int)16).define(Character.valueOf('1'), DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS_CHEAP), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{WorldContent.Block.GlassViewerPhantom.block()}))).define(Character.valueOf('2'), (ItemLike)Items.PHANTOM_MEMBRANE).pattern("111").pattern("121").pattern("111").unlockedBy("has_chorus", WorldRecipeDataGen.has((ItemLike)Items.PHANTOM_MEMBRANE)).save(finished, "xycraft:shaped/glass_viewer_phantom_membrane");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerPhantomDark.block(), (int)8).define(Character.valueOf('1'), DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS_TINTED), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{WorldContent.Block.GlassViewerPhantomDark.block()}))).define(Character.valueOf('2'), (ItemLike)Items.CHORUS_FRUIT).pattern("111").pattern("121").pattern("111").unlockedBy("has_chorus", WorldRecipeDataGen.has((ItemLike)Items.CHORUS_FRUIT)).save(finished, "xycraft:shaped/glass_viewer_phantom_dark_chorus");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerPhantomDark.block(), (int)16).define(Character.valueOf('1'), DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS_TINTED), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{WorldContent.Block.GlassViewerPhantomDark.block()}))).define(Character.valueOf('2'), (ItemLike)Items.PHANTOM_MEMBRANE).pattern("111").pattern("121").pattern("111").unlockedBy("has_chorus", WorldRecipeDataGen.has((ItemLike)Items.PHANTOM_MEMBRANE)).save(finished, "xycraft:shaped/glass_viewer_phantom_dark_membrane");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerPhantomGlowing.block(), (int)8).define(Character.valueOf('1'), DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)XyCraftTags.Items.GlassGlowing.tag()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{WorldContent.Block.GlassViewerPhantomGlowing.block()}))).define(Character.valueOf('2'), (ItemLike)Items.CHORUS_FRUIT).pattern("111").pattern("121").pattern("111").unlockedBy("has_chorus", WorldRecipeDataGen.has((ItemLike)Items.CHORUS_FRUIT)).save(finished, "xycraft:shaped/glass_viewer_phantom_glowing_chorus");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerPhantomGlowing.block(), (int)16).define(Character.valueOf('1'), DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)XyCraftTags.Items.GlassGlowing.tag()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{WorldContent.Block.GlassViewerPhantomGlowing.block()}))).define(Character.valueOf('2'), (ItemLike)Items.PHANTOM_MEMBRANE).pattern("111").pattern("121").pattern("111").unlockedBy("has_chorus", WorldRecipeDataGen.has((ItemLike)Items.PHANTOM_MEMBRANE)).save(finished, "xycraft:shaped/glass_viewer_phantom_glowing_membrane");
        WorldContent.Block.ImmortalStone.forEach((customColors, blockContent) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blockContent.block()).define(Character.valueOf('1'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('2'), Tags.Items.OBSIDIANS).define(Character.valueOf('3'), IngredientUtils.withColor((Tag)XyCraftTags.Items.KiviCloudGroup, (XyCraftColors)customColors)).pattern("121").pattern("232").pattern("121").unlockedBy("has_aluminum_ingot", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/immortal_stone_" + customColors.getSerializedName());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blockContent.block()).define(Character.valueOf('2'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('1'), Tags.Items.OBSIDIANS).define(Character.valueOf('3'), IngredientUtils.withColor((Tag)XyCraftTags.Items.KiviCloudGroup, (XyCraftColors)customColors)).pattern("121").pattern("232").pattern("121").unlockedBy("has_aluminum_ingot", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/immortal_stone_0_" + customColors.getSerializedName());
        });
        WorldContent.Block.ImmortalAluminum.forEach((customColors, blockContent) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blockContent.block()).define(Character.valueOf('1'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('2'), Tags.Items.OBSIDIANS).define(Character.valueOf('3'), IngredientUtils.withColor((Tag)XyCraftTags.Items.AluminumCloudGroup, (XyCraftColors)customColors)).pattern("121").pattern("232").pattern("121").unlockedBy("has_aluminum_ingot", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/immortal_aluminum_" + customColors.getSerializedName());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blockContent.block()).define(Character.valueOf('2'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('1'), Tags.Items.OBSIDIANS).define(Character.valueOf('3'), IngredientUtils.withColor((Tag)XyCraftTags.Items.AluminumCloudGroup, (XyCraftColors)customColors)).pattern("121").pattern("232").pattern("121").unlockedBy("has_aluminum_ingot", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/immortal_aluminum_0_" + customColors.getSerializedName());
        });
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AureyBlockMatte.get(DyeColors.Pink).block(), (int)4).define(Character.valueOf('A'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('D'), Tags.Items.DYES).pattern("AAA").pattern("ADA").pattern("AAA").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/aurey_matte");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AureyBlockMatteGlowing.get(DyeColors.Pink).block()).requires((ItemLike)Items.GLOW_INK_SAC).requires((ItemLike)WorldContent.Block.AureyBlockMatte.get(DyeColors.Pink).block()).unlockedBy("has_glow_ink", WorldRecipeDataGen.has((ItemLike)Items.GLOW_INK_SAC)).save(finished, "xycraft:shapeless/aurey_matte_glowing");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerRgb.get(DyeColors.White).block(), (int)4).define(Character.valueOf('1'), Tags.Items.GLASS_BLOCKS_CHEAP).define(Character.valueOf('2'), Tags.Items.DYES).pattern(" 1 ").pattern("121").pattern(" 1 ").unlockedBy("has_dye", WorldRecipeDataGen.has((TagKey)Tags.Items.DYES)).save(finished, "xycraft:shaped/glass_viewer_rgb");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.GlassViewerRgbGlowing.get(DyeColors.White).block()).requires((ItemLike)Items.GLOW_INK_SAC).requires((ItemLike)WorldContent.Block.GlassViewerRgb.get(DyeColors.White).block()).unlockedBy("has_glow_ink", WorldRecipeDataGen.has((ItemLike)Items.GLOW_INK_SAC)).save(finished, "xycraft:shapeless/glass_viewer_rgb_glowing");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AluminumTorch.item(), (int)2).define(Character.valueOf('1'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('2'), Tags.Items.RODS_WOODEN).pattern("1").pattern("2").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/aluminum_torch");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AluminumTorch.item(), (int)4).define(Character.valueOf('1'), XyCraftTags.Items.AluminumRaw.tag()).define(Character.valueOf('2'), Tags.Items.RODS_WOODEN).pattern("1").pattern("2").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumRaw.tag())).save(finished, "xycraft:shaped/aluminum_torch_raw");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.CopperTorch.item(), (int)2).define(Character.valueOf('1'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('2'), Tags.Items.RODS_WOODEN).pattern("1").pattern("2").unlockedBy("has_copper", WorldRecipeDataGen.has((TagKey)Tags.Items.INGOTS_COPPER)).save(finished, "xycraft:shaped/copper_torch");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.CopperTorch.item(), (int)4).define(Character.valueOf('1'), Tags.Items.RAW_MATERIALS_COPPER).define(Character.valueOf('2'), Tags.Items.RODS_WOODEN).pattern("1").pattern("2").unlockedBy("has_copper", WorldRecipeDataGen.has((TagKey)Tags.Items.RAW_MATERIALS_COPPER)).save(finished, "xycraft:shaped/copper_torch_raw");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.LampRgbGlowing.get(DyeColors.White).block(), (int)1).define(Character.valueOf('1'), Tags.Items.GLASS_BLOCKS_CHEAP).define(Character.valueOf('2'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('3'), (ItemLike)Blocks.GLOWSTONE).define(Character.valueOf('4'), Tags.Items.DUSTS_REDSTONE).pattern("121").pattern("434").pattern("121").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/lamp_rgb");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)WorldContent.Block.LampRgbGlowing.get(DyeColors.White).block(), (int)1).define(Character.valueOf('1'), Tags.Items.GLASS_BLOCKS_CHEAP).define(Character.valueOf('2'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('3'), (ItemLike)Blocks.GLOWSTONE).define(Character.valueOf('4'), XyCraftTags.Items.AluminumIngot.tag()).pattern("121").pattern("434").pattern("121").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/lamp_rgb_r");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)WorldContent.Block.LampRgbGlowingInverted.get(DyeColors.White).block(), (int)1).requires((ItemLike)WorldContent.Block.LampRgbGlowing.get(DyeColors.White).block()).unlockedBy("has_lamp", WorldRecipeDataGen.has((ItemLike)WorldContent.Block.LampRgbGlowing.get(DyeColors.White).block())).save(finished, "xycraft:shapeless/lamp_rgb_inverted");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)WorldContent.Block.LampRgbGlowing.get(DyeColors.White).block(), (int)1).requires((ItemLike)WorldContent.Block.LampRgbGlowingInverted.get(DyeColors.White).block()).unlockedBy("has_lamp", WorldRecipeDataGen.has((ItemLike)WorldContent.Block.LampRgbGlowingInverted.get(DyeColors.White).block())).save(finished, "xycraft:shapeless/lamp_rgb");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)WorldContent.Block.LampLantern.get(DyeColors.White).block(), (int)2).define(Character.valueOf('X'), XyCraftTags.Items.XychoriumGem.tag()).define(Character.valueOf('D'), Tags.Items.DYES).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_CHEAP).define(Character.valueOf('K'), (ItemLike)WorldContent.Block.Kivi.block()).define(Character.valueOf('A'), XyCraftTags.Items.AluminumNugget.tag()).pattern(" A ").pattern("GDG").pattern("KXK").unlockedBy("has_aluminum", WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.XychoriumGem.tag())).save(finished, "xycraft:shaped/lamp_pole");
        for (XyCraftColors color : XyCraftColors.values()) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AluminumBricksCloud.get(color).block(), (int)2).define(Character.valueOf('1'), XyCraftTags.Items.AluminumIngot.tag()).define(Character.valueOf('2'), IngredientUtils.withColor((Tag)XyCraftTags.Items.XychoriumGem, (XyCraftColors)color)).pattern("12").pattern("21").unlockedBy("has_" + XyCraftTags.Items.AluminumIngot.tag().location().getPath(), WorldRecipeDataGen.has((TagKey)XyCraftTags.Items.AluminumIngot.tag())).save(finished, "xycraft:shaped/" + WorldContent.Block.AluminumBricksCloud.get(color).id().getPath());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AluminumBricksCloud.get(color).block(), (int)2).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.AluminumBricks.block()).define(Character.valueOf('2'), IngredientUtils.withColor((Tag)XyCraftTags.Items.XychoriumGem, (XyCraftColors)color)).pattern("12").pattern("21").unlockedBy("has_" + WorldContent.Block.AluminumBricks.id().getPath(), WorldRecipeDataGen.has((ItemLike)WorldContent.Block.AluminumBricks.block())).save(finished, "xycraft:shaped/" + WorldContent.Block.AluminumBricksCloud.get(color).id().getPath() + "_a");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.AluminumTilesCloud.get(color).block(), (int)4).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.AluminumBricksCloud.get(color).item()).pattern("11").pattern("11").unlockedBy("has_" + WorldContent.Block.AluminumBricksCloud.get(color).id().getPath(), WorldRecipeDataGen.has((ItemLike)WorldContent.Block.AluminumBricksCloud.get(color).block())).save(finished, "xycraft:shaped/" + WorldContent.Block.AluminumTilesCloud.get(color).id().getPath());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.KiviBricksCloud.get(color).block(), (int)2).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.Kivi.block()).define(Character.valueOf('2'), (ItemLike)WorldContent.Item.XychoriumGem.get(color).item()).pattern("12").pattern("21").unlockedBy("has_" + WorldContent.Block.Kivi.id().getPath(), WorldRecipeDataGen.has((ItemLike)WorldContent.Block.Kivi.block())).save(finished, "xycraft:shaped/" + WorldContent.Block.KiviBricksCloud.get(color).id().getPath());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.KiviTilesCloud.get(color).block(), (int)4).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.KiviBricksCloud.get(color).item()).pattern("11").pattern("11").unlockedBy("has_" + WorldContent.Block.KiviBricksCloud.get(color).id().getPath(), WorldRecipeDataGen.has((ItemLike)WorldContent.Block.KiviBricksCloud.get(color).block())).save(finished, "xycraft:shaped/" + WorldContent.Block.KiviTilesCloud.get(color).id().getPath());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.AluminumCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.AluminumBricksCloud.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.AluminumCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.AluminumTilesCloud.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.AluminumCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.AluminumPillar.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.AluminumCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.AluminumTrim.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.KiviCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.KiviBricksCloud.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.KiviCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.KiviTilesCloud.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.KiviCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.KiviPillar.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.KiviCloudGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.KiviTrim.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.InvertedGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.InvertedBricksCloud.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.InvertedGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.InvertedTilesCloud.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.InvertedGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.MatteXychoriumBricks.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.InvertedGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.MatteXychoriumBricksShiny.get(color).block());
            this.buildStoneCutting(finished, IngredientUtils.composite((Tag[])new Tag[]{XyCraftTags.Items.InvertedGroup, (Tag)XyCraftTags.Items.XyColor.get(color)}), (ItemLike)WorldContent.Block.MatteXychoriumLayersShiny.get(color).block());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.InvertedBricksCloud.get(color).block(), (int)4).define(Character.valueOf('1'), (ItemLike)WorldContent.Item.XychoriumGem.get(color).item()).pattern("11").pattern("11").unlockedBy("has_" + WorldContent.Item.XychoriumGem.get(color).id().getPath(), WorldRecipeDataGen.has((ItemLike)WorldContent.Item.XychoriumGem.get(color).item())).save(finished, "xycraft:shaped/" + WorldContent.Block.InvertedBricksCloud.get(color).id().getPath());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)WorldContent.Block.InvertedTilesCloud.get(color).block(), (int)4).define(Character.valueOf('1'), (ItemLike)WorldContent.Block.InvertedBricksCloud.get(color).item()).pattern("11").pattern("11").unlockedBy("has_" + WorldContent.Block.InvertedBricksCloud.get(color).id().getPath(), WorldRecipeDataGen.has((ItemLike)WorldContent.Block.InvertedBricksCloud.get(color).block())).save(finished, "xycraft:shaped/" + WorldContent.Block.InvertedTilesCloud.get(color).id().getPath());
        }
    }

    public void buildStoneCutting(@NotNull RecipeOutput finished, Ingredient in, ItemLike out) {
        String outName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)out.asItem())).getPath();
        SingleItemRecipeBuilder.stonecutting((Ingredient)DifferenceIngredient.of((Ingredient)in, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{out})), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)out).unlockedBy("has_for_" + outName, WorldRecipeDataGen.has((ItemLike)Arrays.stream(in.getItems()).findFirst().orElse(ItemStack.EMPTY).getItem())).save(finished, "xycraft:stonecutting/" + outName);
    }

    public void buildStoneCutting(@NotNull RecipeOutput finished, TagKey<Item> in, ItemLike out) {
        String outName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)out.asItem())).getPath();
        SingleItemRecipeBuilder.stonecutting((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.of(in), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{out})), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)out).unlockedBy("has_for_" + outName, WorldRecipeDataGen.has(in)).save(finished, "xycraft:stonecutting/" + outName);
    }

    public void buildCompactingRecipe(RecipeOutput finished, ItemLike packaged, ItemLike unpackaged, TagKey<Item> unlockTag) {
        this.buildCompactingRecipe(finished, packaged, unpackaged, Ingredient.of(unlockTag), unlockTag);
    }

    public void buildCompactingRecipe(RecipeOutput finished, ItemLike packaged, ItemLike unpackaged, Ingredient unpackagedIngredient, TagKey<Item> unlockTag) {
        String unpackagedName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)unpackaged.asItem())).getPath();
        String packagedName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)packaged.asItem())).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)packaged).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), unpackagedIngredient).define(Character.valueOf('B'), unpackaged).unlockedBy("has_" + unpackagedName, WorldRecipeDataGen.has(unlockTag)).save(finished, "xycraft:packing/" + packagedName + "_forced");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)unpackaged, (int)9).unlockedBy("has_" + packagedName, WorldRecipeDataGen.has((ItemLike)packaged)).requires(Ingredient.of((ItemLike[])new ItemLike[]{packaged}), 1).save(finished, "xycraft:unpacking/" + unpackagedName);
    }

    public void buildCompactingRecipe(ItemLike packaged, ItemLike unpackaged, TagKey<Item> inputTag, @NotNull RecipeOutput finished) {
        String unpackagedName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)unpackaged.asItem())).getPath();
        String packagedName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)packaged.asItem())).getPath();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)packaged).unlockedBy("has_" + unpackagedName, inputTag == null ? WorldRecipeDataGen.has((ItemLike)unpackaged) : WorldRecipeDataGen.has(inputTag)).requires(inputTag == null ? Ingredient.of((ItemLike[])new ItemLike[]{unpackaged}) : Ingredient.of(inputTag), 9).save(finished, "xycraft:compacting/" + unpackagedName);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)unpackaged, (int)9).unlockedBy("has_" + packagedName, WorldRecipeDataGen.has((ItemLike)packaged)).requires(Ingredient.of((ItemLike[])new ItemLike[]{packaged}), 1).save(finished, "xycraft:unpacking/" + unpackagedName);
    }

    public void buildCompactingRecipe(ItemLike packaged, ItemLike unpackaged, TagKey<Item> inputTag, TagKey<Item> otherTag, @NotNull RecipeOutput finished) {
        String unpackagedName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)unpackaged.asItem())).getPath();
        String packagedName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)packaged.asItem())).getPath();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)packaged).unlockedBy("has_" + unpackagedName, WorldRecipeDataGen.has(inputTag)).requires(Ingredient.of(inputTag), 9).save(finished, "xycraft:compacting/" + unpackagedName);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)unpackaged, (int)9).unlockedBy("has_" + packagedName, WorldRecipeDataGen.has(otherTag)).requires(Ingredient.of(otherTag), 1).save(finished, "xycraft:unpacking/" + unpackagedName);
    }
}

