/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.data;

import com.mojang.serialization.Codec;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.common.config.CommonConfig;
import earth.terrarium.tempad.common.data.HistoricalLocation;
import earth.terrarium.tempad.common.data.TravelHistoryAttachment;
import earth.terrarium.tempad.common.utils.CodecUtilsKt;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KProperty1;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 -2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001-B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\u001a\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0003H\u0096\u0001J\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0003J\t\u0010\u001d\u001a\u00020\u0018H\u0096\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR$\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030 0\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Learth/terrarium/tempad/common/data/TravelHistoryAttachment;", "", "Ljava/util/Date;", "Learth/terrarium/tempad/common/data/HistoricalLocation;", "history", "", "<init>", "(Ljava/util/Map;)V", "()V", "getHistory", "()Ljava/util/Map;", "plusAssign", "", "historicalLocation", "logLocation", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "marker", "Lnet/minecraft/resources/ResourceLocation;", "backtrackTo", "time", "relevantHistory", "getRelevantHistory", "containsKey", "", "key", "containsValue", "value", "get", "isEmpty", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "Companion", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nTravelHistoryAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TravelHistoryAttachment.kt\nearth/terrarium/tempad/common/data/TravelHistoryAttachment\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,93:1\n535#2:94\n520#2,6:95\n*S KotlinDebug\n*F\n+ 1 TravelHistoryAttachment.kt\nearth/terrarium/tempad/common/data/TravelHistoryAttachment\n*L\n92#1:94\n92#1:95,6\n*E\n"})
public final class TravelHistoryAttachment
implements Map<Date, HistoricalLocation>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Date, HistoricalLocation> history;
    private static final Codec<TravelHistoryAttachment> CODEC = ExtensionsKt.to(CodecUtilsKt.getDATE_CODEC(), HistoricalLocation.Companion.getCODEC()).xmap(arg_0 -> TravelHistoryAttachment.CODEC$lambda$2(TravelHistoryAttachment::CODEC$lambda$1, arg_0), arg_0 -> TravelHistoryAttachment.CODEC$lambda$3((Function1)Companion.CODEC.2.INSTANCE, arg_0));
    private static final ByteCodec<TravelHistoryAttachment> BYTE_CODEC = ExtensionsKt.to(CodecUtilsKt.getDATE_BYTE_CODEC(), HistoricalLocation.Companion.getBYTE_CODEC()).map(TravelHistoryAttachment::BYTE_CODEC$lambda$4, arg_0 -> TravelHistoryAttachment.BYTE_CODEC$lambda$5((KProperty1)Companion.BYTE_CODEC.2.INSTANCE, arg_0));
    @NotNull
    private static final ResourceLocation DIM_EXIT_MARKER = TempadKt.getTempadId("dimension_exit");
    @NotNull
    private static final ResourceLocation DIM_ENTER_MARKER = TempadKt.getTempadId("dimension_enter");
    @NotNull
    private static final ResourceLocation DEATH_MARKER = TempadKt.getTempadId("death");
    @NotNull
    private static final ResourceLocation RESPAWN_MARKER = TempadKt.getTempadId("respawn");

    public TravelHistoryAttachment(@NotNull Map<Date, HistoricalLocation> history) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.history = history;
    }

    @NotNull
    public final Map<Date, HistoricalLocation> getHistory() {
        return this.history;
    }

    public TravelHistoryAttachment() {
        this(new LinkedHashMap());
    }

    public final void plusAssign(@NotNull HistoricalLocation historicalLocation) {
        Intrinsics.checkNotNullParameter((Object)historicalLocation, (String)"historicalLocation");
        this.history.put(new Date(), historicalLocation);
    }

    public final void logLocation(@NotNull LivingEntity entity, @Nullable ResourceLocation marker) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (entity.isSpectator()) break block7;
                Player player = entity instanceof Player ? (Player)entity : null;
                boolean bl = player != null && (player = player.getAbilities()) != null ? player.instabuild : false;
                if (!bl) break block8;
            }
            return;
        }
        if (this.history.isEmpty() || marker != null) {
            ResourceKey resourceKey = entity.level().dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            this.plusAssign(new HistoricalLocation(marker, (ResourceKey<Level>)resourceKey, ExtensionsKt.getPos((Entity)entity)));
            if (this.history.size() > CommonConfig.maxHistorySize) {
                this.history.remove(CollectionsKt.first((Iterable)this.history.keySet()));
            }
            return;
        }
        HistoricalLocation lastPos = (HistoricalLocation)((Map.Entry)CollectionsKt.last((Iterable)this.history.entrySet())).getValue();
        if (Intrinsics.areEqual((Object)entity.level().dimension(), lastPos.getDimension()) && ExtensionsKt.getPos((Entity)entity).distanceToSqr(lastPos.getPos()) < 64.0) {
            return;
        }
        if (this.history.size() > CommonConfig.maxHistorySize) {
            this.history.remove(CollectionsKt.first((Iterable)this.history.keySet()));
        }
        ResourceKey resourceKey = entity.level().dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        this.plusAssign(new HistoricalLocation(null, (ResourceKey<Level>)resourceKey, ExtensionsKt.getPos((Entity)entity)));
    }

    public static /* synthetic */ void logLocation$default(TravelHistoryAttachment travelHistoryAttachment, LivingEntity livingEntity, ResourceLocation resourceLocation, int n, Object object) {
        if ((n & 2) != 0) {
            resourceLocation = null;
        }
        travelHistoryAttachment.logLocation(livingEntity, resourceLocation);
    }

    public final void backtrackTo(@NotNull LivingEntity entity, @NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        HistoricalLocation historicalLocation = this.history.get(time);
        if (historicalLocation == null) {
            return;
        }
        List ids = new ArrayList();
        for (Date historicalTime : this.history.keySet()) {
            if (historicalTime.compareTo(time) < 0) continue;
            ids.add(historicalTime);
        }
        for (Date id : ids) {
            this.history.remove(id);
        }
        ServerLevel serverLevel = ExtensionsKt.get(entity.getServer(), historicalLocation.getDimension());
        Intrinsics.checkNotNull((Object)serverLevel);
        entity.changeDimension(new DimensionTransition(serverLevel, historicalLocation.getPos(), Vec3.ZERO, 0.0f, 0.0f, false, DimensionTransition.DO_NOTHING));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Date, HistoricalLocation> getRelevantHistory() {
        void $this$filterTo$iv$iv;
        Map<Date, HistoricalLocation> $this$filter$iv = this.history;
        boolean $i$f$filter = false;
        Map<Date, HistoricalLocation> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((HistoricalLocation)it.getValue()).getMarker() != null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public boolean containsKey(@NotNull Date key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.history.containsKey(key);
    }

    public boolean containsValue(@NotNull HistoricalLocation value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.history.containsValue(value);
    }

    @Nullable
    public HistoricalLocation get(@NotNull Date key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.history.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    @NotNull
    public Set<Map.Entry<Date, HistoricalLocation>> getEntries() {
        return this.history.entrySet();
    }

    @NotNull
    public Set<Date> getKeys() {
        return this.history.keySet();
    }

    public int getSize() {
        return this.history.size();
    }

    @NotNull
    public Collection<HistoricalLocation> getValues() {
        return this.history.values();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation put(Date key, HistoricalLocation value) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends Date, ? extends HistoricalLocation> from) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation remove(Object key) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super Date, ? super HistoricalLocation, ? extends HistoricalLocation> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation putIfAbsent(Date p0, HistoricalLocation p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(Date p0, HistoricalLocation p1, HistoricalLocation p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation replace(Date p0, HistoricalLocation p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation computeIfAbsent(Date p0, Function<? super Date, ? extends HistoricalLocation> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation computeIfPresent(Date p0, BiFunction<? super Date, ? super HistoricalLocation, ? extends HistoricalLocation> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation compute(Date p0, BiFunction<? super Date, ? super HistoricalLocation, ? extends HistoricalLocation> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public HistoricalLocation merge(Date p0, HistoricalLocation p1, BiFunction<? super HistoricalLocation, ? super HistoricalLocation, ? extends HistoricalLocation> p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    private static final TravelHistoryAttachment CODEC$lambda$1(Map it) {
        Intrinsics.checkNotNull((Object)it);
        return new TravelHistoryAttachment(MapsKt.toMutableMap((Map)it));
    }

    private static final TravelHistoryAttachment CODEC$lambda$2(Function1 $tmp0, Object p0) {
        return (TravelHistoryAttachment)$tmp0.invoke(p0);
    }

    private static final Map CODEC$lambda$3(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final TravelHistoryAttachment BYTE_CODEC$lambda$4(Map it) {
        Intrinsics.checkNotNull((Object)it);
        return new TravelHistoryAttachment(MapsKt.toMutableMap((Map)it));
    }

    private static final Map BYTE_CODEC$lambda$5(KProperty1 $tmp0, TravelHistoryAttachment p0) {
        return (Map)((Function1)$tmp0).invoke((Object)p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R7\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR7\u0010\u000b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\f0\f\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Learth/terrarium/tempad/common/data/TravelHistoryAttachment$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Learth/terrarium/tempad/common/data/TravelHistoryAttachment;", "kotlin.jvm.PlatformType", "getCODEC", "()Lcom/mojang/serialization/Codec;", "Lcom/mojang/serialization/Codec;", "BYTE_CODEC", "Lcom/teamresourceful/bytecodecs/base/ByteCodec;", "getBYTE_CODEC", "()Lcom/teamresourceful/bytecodecs/base/ByteCodec;", "Lcom/teamresourceful/bytecodecs/base/ByteCodec;", "DIM_EXIT_MARKER", "Lnet/minecraft/resources/ResourceLocation;", "getDIM_EXIT_MARKER", "()Lnet/minecraft/resources/ResourceLocation;", "DIM_ENTER_MARKER", "getDIM_ENTER_MARKER", "DEATH_MARKER", "getDEATH_MARKER", "RESPAWN_MARKER", "getRESPAWN_MARKER", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final Codec<TravelHistoryAttachment> getCODEC() {
            return CODEC;
        }

        public final ByteCodec<TravelHistoryAttachment> getBYTE_CODEC() {
            return BYTE_CODEC;
        }

        @NotNull
        public final ResourceLocation getDIM_EXIT_MARKER() {
            return DIM_EXIT_MARKER;
        }

        @NotNull
        public final ResourceLocation getDIM_ENTER_MARKER() {
            return DIM_ENTER_MARKER;
        }

        @NotNull
        public final ResourceLocation getDEATH_MARKER() {
            return DEATH_MARKER;
        }

        @NotNull
        public final ResourceLocation getRESPAWN_MARKER() {
            return RESPAWN_MARKER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

