/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.data.server;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.util.TranslationKey;
import org.apache.commons.lang3.function.TriFunction;

public class Advancements
implements AdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        AdvancementHolder root = new Advancement.Builder().display(this.displayInfo((ItemLike)ModRegistry.FLUX_SIEVE_ITEM.get(), (Component)TranslationKey.translateAdvancement("root"), (Component)TranslationKey.translateAdvancement("root.desc"), Optional.of(ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/backgrounds/stone.png")), AdvancementType.TASK, false, false, false)).addCriterion("item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.IRON_INGOT})).save(consumer, this.advancementPath("root"));
        BiFunction<Supplier, String, AdvancementHolder> machineBuilder = (registryObject, machine) -> new Advancement.Builder().parent(root).display(this.displayItem((Supplier<? extends Item>)registryObject, (String)machine)).addCriterion("has_" + machine, this.hasItem((ItemLike)registryObject.get())).save(consumer, this.advancementPath((String)machine));
        AdvancementHolder sieve = machineBuilder.apply((Supplier)ModRegistry.FLUX_SIEVE_ITEM, "flux_sieve");
        AdvancementHolder hammer = machineBuilder.apply((Supplier)ModRegistry.FLUX_HAMMER_ITEM, "flux_hammer");
        AdvancementHolder compactor = machineBuilder.apply((Supplier)ModRegistry.FLUX_COMPACTOR_ITEM, "flux_compactor");
        TriFunction upgradeBuilder = (registryObject, upgrade, parent) -> new Advancement.Builder().parent(parent).display(this.displayItem((Supplier<? extends Item>)registryObject, (String)upgrade)).addCriterion("has_" + upgrade, this.hasItem((ItemLike)registryObject.get())).save(consumer, this.advancementPath((String)upgrade));
        AdvancementHolder gold = (AdvancementHolder)upgradeBuilder.apply(ModRegistry.GOLD_UPGRADE, (Object)"gold_upgrade", (Object)root);
        AdvancementHolder diamond = (AdvancementHolder)upgradeBuilder.apply(ModRegistry.DIAMOND_UPGRADE, (Object)"diamond_upgrade", (Object)gold);
        AdvancementHolder netherite = (AdvancementHolder)upgradeBuilder.apply(ModRegistry.NETHERITE_UPGRADE, (Object)"netherite_upgrade", (Object)diamond);
    }

    private String advancementPath(String key) {
        return String.format("%s:%s", "exmachinis", key);
    }

    private Criterion<InventoryChangeTrigger.TriggerInstance> hasItem(ItemLike item) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()});
    }

    private DisplayInfo displayItem(Supplier<? extends Item> item, String translationKey) {
        return this.displayInfo((ItemLike)item.get(), (Component)TranslationKey.translateAdvancement(translationKey), (Component)TranslationKey.translateAdvancement(translationKey + ".desc"), Optional.empty(), AdvancementType.TASK, true, true, false);
    }

    private DisplayInfo displayInfo(ItemLike title, Component description, Component icon, Optional<ResourceLocation> background, AdvancementType frame, boolean showToast, boolean announceChat, boolean hidden) {
        return new DisplayInfo(new ItemStack((ItemLike)title.asItem()), description, icon, background, frame, showToast, announceChat, hidden);
    }
}

