/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.data.server;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.allthemods.alltheores.blocks.BlockList;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.data.builders.CompactingRecipeBuilder;
import thedarkcolour.exdeorum.registry.EItems;

public class CraftingRecipes
extends RecipeProvider {
    public CraftingRecipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider).group("exmachinis");
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.buildCraftingRecipes(consumer);
        this.buildCompactingRecipes(consumer);
    }

    protected void buildCraftingRecipes(RecipeOutput consumer) {
        this.shaped((ItemLike)ModRegistry.GOLD_UPGRADE.get()).pattern("tct").pattern("gdg").pattern("ggg").define(Character.valueOf('t'), (ItemLike)Items.CYAN_TERRACOTTA).define(Character.valueOf('c'), Tags.Items.DYES_GREEN).define(Character.valueOf('d'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_gold_ingot", CraftingRecipes.has((TagKey)Tags.Items.INGOTS_GOLD)).save(consumer);
        this.shaped((ItemLike)ModRegistry.DIAMOND_UPGRADE.get()).pattern("nun").pattern("nun").pattern("nun").define(Character.valueOf('u'), (ItemLike)ModRegistry.GOLD_UPGRADE.get()).define(Character.valueOf('n'), Tags.Items.GEMS_DIAMOND).unlockedBy("has_diamond", CraftingRecipes.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(consumer);
        this.shaped((ItemLike)ModRegistry.NETHERITE_UPGRADE.get()).pattern("nun").pattern("nun").pattern("nun").define(Character.valueOf('u'), (ItemLike)ModRegistry.DIAMOND_UPGRADE.get()).define(Character.valueOf('n'), Tags.Items.INGOTS_NETHERITE).unlockedBy("has_netherite_ingot", CraftingRecipes.has((TagKey)Tags.Items.INGOTS_NETHERITE)).save(consumer);
        this.shaped((ItemLike)ModRegistry.COMPARATOR_UPGRADE.get()).pattern("tct").pattern("gdg").pattern("ggg").define(Character.valueOf('t'), (ItemLike)Items.CYAN_TERRACOTTA).define(Character.valueOf('c'), Tags.Items.DYES_GREEN).define(Character.valueOf('d'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_comparator", CraftingRecipes.has((ItemLike)Items.COMPARATOR)).save(consumer);
        this.shaped((ItemLike)ModRegistry.FLUX_SIEVE_ITEM.get()).pattern("bbb").pattern("bsb").pattern("ihi").define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('s'), ModRegistry.SIEVES).define(Character.valueOf('i'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('h'), (ItemLike)Items.HOPPER).unlockedBy("has_sieve", CraftingRecipes.has(ModRegistry.SIEVES)).save(consumer);
        Item hammerItem = (Item)EItems.DIAMOND_HAMMER.get();
        this.shaped((ItemLike)ModRegistry.FLUX_HAMMER_ITEM.get()).pattern("ggg").pattern("gdg").pattern("ihi").define(Character.valueOf('g'), Tags.Items.GLASS_PANES).define(Character.valueOf('d'), (ItemLike)hammerItem).define(Character.valueOf('i'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('h'), (ItemLike)Items.HOPPER).unlockedBy("has_diamond_hammer", CraftingRecipes.has((ItemLike)hammerItem)).save(consumer);
        this.shaped((ItemLike)ModRegistry.FLUX_COMPACTOR_ITEM.get()).pattern("ipi").pattern("pcp").pattern("ihi").define(Character.valueOf('i'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('p'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('h'), (ItemLike)Items.HOPPER).unlockedBy("has_hopper", CraftingRecipes.has((ItemLike)Items.HOPPER)).save(consumer);
        this.shaped((ItemLike)ModRegistry.ITEM_BUFFER_ITEM.get()).pattern("iri").pattern("ici").pattern("ihi").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('h'), (ItemLike)Items.HOPPER).unlockedBy("has_hopper", CraftingRecipes.has((ItemLike)Items.HOPPER)).save(consumer);
    }

    protected void buildCompactingRecipes(RecipeOutput consumer) {
        CompactingRecipeBuilder.builder(Objects.requireNonNull(Items.IRON_ORE)).setInput(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.IRON_ORE_CHUNK.get()}), 4).build(consumer);
        CompactingRecipeBuilder.builder(Objects.requireNonNull(Items.GOLD_ORE)).setInput(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.GOLD_ORE_CHUNK.get()}), 4).build(consumer);
        CompactingRecipeBuilder.builder(Objects.requireNonNull(Items.COPPER_ORE)).setInput(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)EItems.COPPER_ORE_CHUNK.get()}), 4).build(consumer);
        Map<DeferredItem, DeferredItem> oreMap = Map.ofEntries(Map.entry(BlockList.LEAD_ORE_ITEM, EItems.LEAD_ORE_CHUNK), Map.entry(BlockList.NICKEL_ORE_ITEM, EItems.NICKEL_ORE_CHUNK), Map.entry(BlockList.SILVER_ORE_ITEM, EItems.SILVER_ORE_CHUNK), Map.entry(BlockList.TIN_ORE_ITEM, EItems.TIN_ORE_CHUNK), Map.entry(BlockList.ALUMINUM_ORE_ITEM, EItems.ALUMINUM_ORE_CHUNK), Map.entry(BlockList.PLATINUM_ORE_ITEM, EItems.PLATINUM_ORE_CHUNK), Map.entry(BlockList.URANIUM_ORE_ITEM, EItems.URANIUM_ORE_CHUNK), Map.entry(BlockList.ZINC_ORE_ITEM, EItems.ZINC_ORE_CHUNK), Map.entry(BlockList.IRIDIUM_ORE_ITEM, EItems.IRIDIUM_ORE_CHUNK), Map.entry(BlockList.OSMIUM_ORE_ITEM, EItems.OSMIUM_ORE_CHUNK));
        oreMap.forEach((ore, chunk) -> CompactingRecipeBuilder.builder((Supplier<Item>)ore).setInput((ItemLike)chunk, 4).build(consumer));
        Map<Block, Item> pebbleMap = Map.ofEntries(Map.entry(Blocks.ANDESITE, (Item)EItems.ANDESITE_PEBBLE.get()), Map.entry(Blocks.BASALT, (Item)EItems.BASALT_PEBBLE.get()), Map.entry(Blocks.BLACKSTONE, (Item)EItems.BLACKSTONE_PEBBLE.get()), Map.entry(Blocks.STONE, (Item)EItems.STONE_PEBBLE.get()), Map.entry(Blocks.CALCITE, (Item)EItems.CALCITE_PEBBLE.get()), Map.entry(Blocks.DEEPSLATE, (Item)EItems.DEEPSLATE_PEBBLE.get()), Map.entry(Blocks.DIORITE, (Item)EItems.DIORITE_PEBBLE.get()), Map.entry(Blocks.GRANITE, (Item)EItems.GRANITE_PEBBLE.get()), Map.entry(Blocks.TUFF, (Item)EItems.TUFF_PEBBLE.get()));
        pebbleMap.forEach((block, pebble) -> CompactingRecipeBuilder.builder(block.asItem()).setInput(Ingredient.of((ItemLike[])new ItemLike[]{pebble}), 4).build(consumer));
    }
}

