/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.base;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.items.ComparatorUpgradeItem;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.base.DataHolder;
import net.permutated.exmachinis.machines.base.DataHolderClient;
import net.permutated.exmachinis.machines.base.DataHolderServer;
import net.permutated.exmachinis.util.WorkStatus;

public abstract class AbstractMachineMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess containerLevelAccess;
    protected final DataHolder dataHolder;
    protected final boolean enableMeshSlot;
    protected final boolean enableComparatorSlot;
    protected final int totalSlots;

    protected AbstractMachineMenu(@Nullable MenuType<?> containerType, int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        super(containerType, windowId);
        this.enableMeshSlot = buf.readBoolean();
        this.enableComparatorSlot = buf.readBoolean();
        this.totalSlots = this.enableMeshSlot ? 11 : (this.enableComparatorSlot ? 20 : 10);
        BlockPos pos = buf.readBlockPos();
        Level level = playerInventory.player.getCommandSenderWorld();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.containerLevelAccess = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
            BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
            if (blockEntity instanceof AbstractMachineTile) {
                AbstractMachineTile tile = (AbstractMachineTile)blockEntity;
                this.dataHolder = new DataHolderServer(tile);
                this.registerHandlerSlots(tile.overlayItemhandler);
            } else {
                ExMachinis.LOGGER.error("Tried to create DataHolder on server, but did not find matching tile for pos: {}", (Object)pos);
                this.dataHolder = new DataHolderClient();
            }
        } else {
            this.containerLevelAccess = ContainerLevelAccess.NULL;
            this.dataHolder = new DataHolderClient();
            this.registerHandlerSlots((IItemHandler)new ItemStackHandler(this.totalSlots));
        }
        this.registerPlayerSlots((IItemHandler)new InvWrapper((Container)playerInventory));
        this.registerDataSlots();
    }

    protected abstract Supplier<Block> getBlock();

    protected WorkStatus getWorkStatus() {
        return this.dataHolder.getWorkStatus();
    }

    public boolean stillValid(Player playerEntity) {
        return AbstractMachineMenu.stillValid((ContainerLevelAccess)this.containerLevelAccess, (Player)playerEntity, (Block)this.getBlock().get());
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        int inventorySize = this.totalSlots;
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index < inventorySize ? !this.moveItemStackTo(stack, inventorySize, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, inventorySize, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void registerHandlerSlots(IItemHandler handler) {
        int index = 0;
        int upgradeOffsetX = this.enableComparatorSlot ? 134 : 116;
        this.addSlot((Slot)new FilteredSlot(handler, index++, upgradeOffsetX, 54, stack -> stack.getItem() instanceof UpgradeItem));
        if (this.enableMeshSlot) {
            this.addSlot((Slot)new FilteredSlot(handler, index++, 80, 36, ExNihiloAPI::isMeshItem));
        }
        if (this.enableComparatorSlot) {
            this.addSlot((Slot)new FilteredSlot(handler, index++, upgradeOffsetX, 18, stack -> stack.getItem() instanceof ComparatorUpgradeItem));
        }
        int width = this.enableComparatorSlot ? 6 : 3;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < width; ++j) {
                this.addSlot((Slot)new SlotItemHandler(handler, index++, 8 + j * 18, 18 + i * 18));
            }
        }
    }

    public void registerPlayerSlots(IItemHandler wrappedInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler(wrappedInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new SlotItemHandler(wrappedInventory, i, 8 + i * 18, 142));
        }
    }

    public void registerDataSlots() {
        this.addDataSlot(this.dataHolder::getWork, this.dataHolder::setWork);
        this.addDataSlot(this.dataHolder::getMaxWork, this.dataHolder::setMaxWork);
        this.addDataSlot(() -> this.dataHolder.getWorkStatus().ordinal(), this.dataHolder::setWorkStatus);
        this.addDataSlot(() -> this.dataHolder.getMaxEnergy() & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getMaxEnergy() & 0xFFFF0000;
            this.dataHolder.setMaxEnergy(energyStored + (value & 0xFFFF));
        });
        this.addDataSlot(() -> this.dataHolder.getMaxEnergy() >> 16 & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getMaxEnergy() & 0xFFFF;
            this.dataHolder.setMaxEnergy(energyStored | value << 16);
        });
        this.addDataSlot(() -> this.dataHolder.getEnergy() & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getEnergy() & 0xFFFF0000;
            this.dataHolder.setEnergy(energyStored + (value & 0xFFFF));
        });
        this.addDataSlot(() -> this.dataHolder.getEnergy() >> 16 & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getEnergy() & 0xFFFF;
            this.dataHolder.setEnergy(energyStored | value << 16);
        });
    }

    private void addDataSlot(IntSupplier getter, IntConsumer setter) {
        this.addDataSlot(new LambdaDataSlot(getter, setter));
    }

    static class FilteredSlot
    extends SlotItemHandler {
        protected final Predicate<ItemStack> filter;

        public FilteredSlot(IItemHandler handler, int index, int x, int y, Predicate<ItemStack> filter) {
            super(handler, index, x, y);
            this.filter = filter;
        }

        public boolean mayPlace(ItemStack stack) {
            return this.filter.test(stack);
        }
    }

    static class LambdaDataSlot
    extends DataSlot {
        private final IntSupplier getter;
        private final IntConsumer setter;

        public LambdaDataSlot(IntSupplier getter, IntConsumer setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public int get() {
            return this.getter.getAsInt();
        }

        public void set(int pValue) {
            this.setter.accept(pValue);
        }
    }
}

