/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.base;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.permutated.exmachinis.ConfigHolder;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.items.ComparatorUpgradeItem;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.util.OverlayItemHandler;
import net.permutated.exmachinis.util.PipeItemHandler;
import net.permutated.exmachinis.util.WorkStatus;

public abstract class AbstractMachineTile
extends BlockEntity {
    protected int version = 1;
    protected WorkStatus workStatus = WorkStatus.NONE;
    protected final MachineEnergyStorage energyStorage = new MachineEnergyStorage(this.getMaxEnergyStorage(), this.getMaxEnergyTransfer());
    protected final ItemStackHandler itemStackHandler = new MachineItemStackHandler(this.enableComparatorSlot() ? 18 : 9){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AbstractMachineTile.this.isItemValid(stack);
        }
    };
    protected final ItemStackHandler upgradeStackHandler = new MachineItemStackHandler(this.enableMeshSlot() || this.enableComparatorSlot() ? 2 : 1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.getItem() instanceof UpgradeItem;
            }
            return AbstractMachineTile.this.enableMeshSlot() && ExNihiloAPI.isMeshItem(stack) || AbstractMachineTile.this.enableComparatorSlot() && stack.getItem() instanceof ComparatorUpgradeItem;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 3 : 1;
        }
    };
    protected final IItemHandler pipeItemHandler = new PipeItemHandler(this.itemStackHandler);
    protected final IItemHandler overlayItemhandler = new OverlayItemHandler(this.itemStackHandler, this.upgradeStackHandler);
    int remainder = 0;
    private long lastTicked = 0L;
    int offset = 0;

    protected AbstractMachineTile(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected int getMaxEnergyStorage() {
        return (Integer)ConfigHolder.SERVER.energyBufferSize.get();
    }

    protected int getMaxEnergyTransfer() {
        return (Integer)ConfigHolder.SERVER.maxEnergyPerTick.get();
    }

    protected int getUpgradeItemsProcessed() {
        ItemStack upgradeStack = this.upgradeStackHandler.getStackInSlot(0);
        Item item = upgradeStack.getItem();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (upgradeStack.getCount() > 0) {
                int upgradeCount = Mth.clamp((int)upgradeStack.getCount(), (int)1, (int)3);
                return upgradeItem.getTier().getItemsProcessed(upgradeCount);
            }
        }
        return 1;
    }

    protected int getUpgradeTickDelay() {
        ItemStack upgradeStack = this.upgradeStackHandler.getStackInSlot(0);
        Item item = upgradeStack.getItem();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            return switch (upgradeItem.getTier()) {
                default -> throw new MatchException(null, null);
                case UpgradeItem.Tier.GOLD -> (Integer)ConfigHolder.SERVER.goldTicksPerOperation.get();
                case UpgradeItem.Tier.DIAMOND -> (Integer)ConfigHolder.SERVER.diamondTicksPerOperation.get();
                case UpgradeItem.Tier.NETHERITE -> (Integer)ConfigHolder.SERVER.netheriteTicksPerOperation.get();
            };
        }
        return (Integer)ConfigHolder.SERVER.goldTicksPerOperation.get();
    }

    protected int getUpgradeEnergyCost() {
        ItemStack upgradeStack = this.upgradeStackHandler.getStackInSlot(0);
        Item item = upgradeStack.getItem();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            return switch (upgradeItem.getTier()) {
                default -> throw new MatchException(null, null);
                case UpgradeItem.Tier.GOLD -> (Integer)ConfigHolder.SERVER.goldEnergyPerBlock.get();
                case UpgradeItem.Tier.DIAMOND -> (Integer)ConfigHolder.SERVER.diamondEnergyPerBlock.get();
                case UpgradeItem.Tier.NETHERITE -> (Integer)ConfigHolder.SERVER.netheriteEnergyPerBlock.get();
            };
        }
        return (Integer)ConfigHolder.SERVER.goldEnergyPerBlock.get();
    }

    protected abstract boolean isItemValid(ItemStack var1);

    protected boolean enableMeshSlot() {
        return false;
    }

    protected boolean enableComparatorSlot() {
        return false;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractMachineTile> blockEntityType) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, (machine, side) -> side == null ? machine.overlayItemhandler : machine.pipeItemHandler);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (machine, side) -> machine.energyStorage);
    }

    public void dropItems() {
        AbstractMachineTile.dropItems(this.level, this.worldPosition, (IItemHandler)this.itemStackHandler);
        AbstractMachineTile.dropItems(this.level, this.worldPosition, (IItemHandler)this.upgradeStackHandler);
    }

    public boolean canTick(int every) {
        long gameTime;
        long l = gameTime = this.level != null ? this.level.getGameTime() : 0L;
        if (gameTime != this.lastTicked) {
            this.lastTicked = gameTime;
            this.remainder = (int)(this.offset(gameTime) % (long)every);
            return this.remainder == 0;
        }
        return false;
    }

    protected long offset(long gameTime) {
        if (this.offset == 0) {
            this.offset += ThreadLocalRandom.current().nextInt(0, 20);
        }
        return gameTime + (long)this.offset;
    }

    public abstract void tick();

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof AbstractMachineTile) {
            AbstractMachineTile machineTile = (AbstractMachineTile)blockEntity;
            machineTile.tick();
        }
    }

    public int getMaxWork() {
        return this.getUpgradeTickDelay();
    }

    public int getWork() {
        return this.remainder;
    }

    public WorkStatus getWorkStatus() {
        return this.workStatus;
    }

    protected static void dropItems(@Nullable Level world, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemstack = itemHandler.getStackInSlot(i);
            if (itemstack.getCount() <= 0 || world == null) continue;
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemstack);
        }
    }

    public void updateContainer(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeBoolean(this.enableMeshSlot());
        packetBuffer.writeBoolean(this.enableComparatorSlot());
        packetBuffer.writeBlockPos(this.worldPosition);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("version", this.version);
        tag.put("energy", this.energyStorage.serializeNBT(registries));
        tag.put("inventory", (Tag)this.itemStackHandler.serializeNBT(registries));
        tag.put("upgrades", (Tag)this.upgradeStackHandler.serializeNBT(registries));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.version = tag.getInt("version");
        this.energyStorage.deserializeNBT(registries, tag.get("energy"));
        this.itemStackHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.upgradeStackHandler.deserializeNBT(registries, tag.getCompound("upgrades"));
        super.loadAdditional(tag, registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    protected void sortSlots() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            int missing = stack.getMaxStackSize() - stack.getCount();
            if (stack.isEmpty() || missing <= 0) continue;
            for (int j = i + 1; j < this.itemStackHandler.getSlots() && missing > 0; ++j) {
                ItemStack simulate;
                ItemStack match = this.itemStackHandler.getStackInSlot(j);
                if (!stack.is(match.getItem()) || (simulate = this.itemStackHandler.extractItem(j, missing, true)).isEmpty() || !this.itemStackHandler.insertItem(i, simulate, true).isEmpty()) continue;
                ItemStack actual = this.itemStackHandler.extractItem(j, simulate.getCount(), false);
                ItemStack result = this.itemStackHandler.insertItem(i, actual, false);
                missing -= actual.getCount();
                if (result.isEmpty()) continue;
                ExMachinis.LOGGER.error("non-empty itemstack returned from sorting: {}", (Object)result);
            }
        }
    }

    public class MachineEnergyStorage
    extends EnergyStorage {
        public MachineEnergyStorage(int capacity, int maxRecieve) {
            super(capacity, maxRecieve, 0);
        }

        public void onEnergyChanged() {
            AbstractMachineTile.this.setChanged();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int rc = super.receiveEnergy(maxReceive, simulate);
            if (rc > 0 && !simulate) {
                this.onEnergyChanged();
            }
            return rc;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int rc = super.extractEnergy(maxExtract, simulate);
            if (rc > 0 && !simulate) {
                this.onEnergyChanged();
            }
            return rc;
        }

        public boolean consumeEnergy(int request, boolean simulate) {
            int consumed = Math.max(0, request);
            if (this.energy > consumed) {
                if (!simulate) {
                    this.energy -= consumed;
                    this.onEnergyChanged();
                }
                return true;
            }
            return false;
        }

        public void deserializeNBT(HolderLookup.Provider provider, @Nullable Tag nbt) {
            if (nbt != null) {
                super.deserializeNBT(provider, nbt);
            }
        }
    }

    public class MachineItemStackHandler
    extends ItemStackHandler {
        Runnable listener;

        public MachineItemStackHandler(int size) {
            super(size);
            this.listener = null;
        }

        protected void onContentsChanged(int slot) {
            if (this.listener != null) {
                this.listener.run();
            }
            AbstractMachineTile.this.setChanged();
        }

        public void setListener(Runnable listener) {
            this.listener = listener;
        }
    }
}

