/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.hammer;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.IContainerFactory;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineMenu;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.hammer.FluxHammerMenu;
import net.permutated.exmachinis.machines.hammer.FluxHammerTile;
import net.permutated.exmachinis.util.BlockUtil;
import net.permutated.exmachinis.util.TranslationKey;

public class FluxHammerBlock
extends AbstractMachineBlock {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)15.0);
    private static final VoxelShape SHAPE_HOPPER = Stream.of(Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)15.0), Block.box((double)5.0, (double)10.0, (double)7.0, (double)13.0, (double)13.0, (double)15.0), Shapes.join((VoxelShape)Block.box((double)13.0, (double)12.0, (double)6.0, (double)15.0, (double)16.0, (double)14.0), (VoxelShape)Shapes.join((VoxelShape)Block.box((double)3.0, (double)12.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0), (VoxelShape)Shapes.join((VoxelShape)Block.box((double)3.0, (double)12.0, (double)6.0, (double)5.0, (double)16.0, (double)14.0), (VoxelShape)Block.box((double)3.0, (double)12.0, (double)4.0, (double)15.0, (double)16.0, (double)6.0), (BooleanOp)BooleanOp.AND), (BooleanOp)BooleanOp.AND), (BooleanOp)BooleanOp.AND)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final EnumMap<Direction, Map.Entry<VoxelShape, VoxelShape>> SHAPE_MAP = new EnumMap(Direction.class);
    public static final DirectionProperty FACING;
    public static final BooleanProperty HOPPER;

    public FluxHammerBlock() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OUTPUT, (Comparable)Direction.NORTH)).setValue((Property)HOPPER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Boolean hopper = (Boolean)blockState.getValue((Property)HOPPER);
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        Map.Entry<VoxelShape, VoxelShape> shapes = SHAPE_MAP.get(facing);
        return Boolean.FALSE.equals(hopper) ? shapes.getKey() : shapes.getValue();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos above = context.getClickedPos().above();
        boolean isAir = context.getLevel().getBlockState(above).isAir();
        Direction opposite = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)opposite)).setValue((Property)OUTPUT, (Comparable)opposite)).setValue((Property)HOPPER, (Comparable)Boolean.valueOf(!isAir));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HOPPER});
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing.equals((Object)Direction.UP)) {
            Boolean current = (Boolean)state.getValue((Property)HOPPER);
            if (facingState.isAir() && Boolean.TRUE.equals(current)) {
                return (BlockState)state.setValue((Property)HOPPER, (Comparable)Boolean.valueOf(false));
            }
            if (!facingState.isAir() && Boolean.FALSE.equals(current)) {
                return (BlockState)state.setValue((Property)HOPPER, (Comparable)Boolean.valueOf(true));
            }
        }
        return state;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluxHammerTile(pos, state);
    }

    @Override
    public BlockEntityType<? extends AbstractMachineTile> getTileType() {
        return ModRegistry.FLUX_HAMMER_TILE.get();
    }

    @Override
    public IContainerFactory<AbstractMachineMenu> containerFactory() {
        return FluxHammerMenu::new;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        tooltip.add((Component)TranslationKey.translateTooltip("hammer1"));
    }

    static {
        Direction.Plane.HORIZONTAL.forEach(direction -> {
            VoxelShape left = BlockUtil.rotateShape(Direction.NORTH, direction, SHAPE);
            VoxelShape right = BlockUtil.rotateShape(Direction.NORTH, direction, SHAPE_HOPPER);
            SHAPE_MAP.put((Direction)direction, Map.entry(left, right));
        });
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        HOPPER = BooleanProperty.create((String)"hopper");
    }
}

