/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.hammer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.hammer.FluxHammerBlock;
import net.permutated.exmachinis.util.ItemStackUtil;
import net.permutated.exmachinis.util.WorkStatus;

public class FluxHammerTile
extends AbstractMachineTile {
    public FluxHammerTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FLUX_HAMMER_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    private void migrate(ServerLevel serverLevel) {
        if (this.version == 1) {
            return;
        }
        if (this.version > 1) {
            ExMachinis.LOGGER.error("Current tile version higher than block version - things may break!");
            return;
        }
        if (this.version == 0) {
            Direction facing = (Direction)this.getBlockState().getValue((Property)FluxHammerBlock.FACING);
            serverLevel.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AbstractMachineBlock.OUTPUT, (Comparable)facing), 2);
            this.version = 1;
            this.setChanged();
        }
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getUpgradeTickDelay())) {
                int quotient;
                this.migrate(serverLevel);
                Boolean enabled = (Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ENABLED);
                if (Boolean.FALSE.equals(enabled)) {
                    this.workStatus = WorkStatus.REDSTONE_DISABLED;
                    return;
                }
                Direction output = (Direction)this.getBlockState().getValue((Property)AbstractMachineBlock.OUTPUT);
                BlockPos outPos = this.getBlockPos().relative(output);
                IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, outPos, (Object)output.getOpposite());
                if (itemHandler == null || itemHandler.getSlots() == 0) {
                    this.workStatus = WorkStatus.MISSING_INVENTORY;
                    return;
                }
                this.workStatus = WorkStatus.WORKING;
                int cost = this.getUpgradeEnergyCost();
                int stored = this.energyStorage.getEnergyStored();
                int maxProcessed = this.getUpgradeItemsProcessed();
                if (stored < cost) {
                    this.workStatus = WorkStatus.OUT_OF_ENERGY;
                    return;
                }
                if (cost > 0 && (quotient = stored / cost) < maxProcessed) {
                    maxProcessed = quotient;
                }
                for (int i = 0; i < this.itemStackHandler.getSlots() && maxProcessed != 0; ++i) {
                    int multiplier;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (stack.isEmpty() || !ExNihiloAPI.canHammer(stack)) continue;
                    ItemStack copy = stack.copy();
                    int count = stack.getCount();
                    if (count >= maxProcessed) {
                        multiplier = maxProcessed;
                        copy.shrink(maxProcessed);
                        maxProcessed = 0;
                    } else {
                        multiplier = count;
                        copy = ItemStack.EMPTY;
                        maxProcessed -= count;
                    }
                    if (!this.processResults(serverLevel, itemHandler, stack, multiplier, true)) {
                        return;
                    }
                    int totalCost = cost * multiplier;
                    boolean result = this.energyStorage.consumeEnergy(totalCost, true);
                    if (!result) {
                        this.workStatus = WorkStatus.OUT_OF_ENERGY;
                        return;
                    }
                    this.itemStackHandler.setStackInSlot(i, copy);
                    this.energyStorage.consumeEnergy(totalCost, false);
                    this.processResults(serverLevel, itemHandler, stack, multiplier, false);
                }
                this.pullFromAbove();
            }
        }
    }

    private boolean processResults(ServerLevel serverLevel, IItemHandler itemHandler, ItemStack stack, int multiplier, boolean simulate) {
        ExNihiloAPI.getHammerResult(serverLevel, stack).stream().map(result -> ItemStackUtil.multiplyStackCount(result, multiplier)).map(output -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate)).forEach(response -> {
            if (!response.isEmpty()) {
                this.workStatus = WorkStatus.INVENTORY_FULL;
            }
        });
        return this.workStatus == WorkStatus.WORKING;
    }

    private void pullFromAbove() {
        IItemHandler inputItemHandler = null;
        if (this.level != null && ((Boolean)this.getBlockState().getValue((Property)FluxHammerBlock.HOPPER)).equals(Boolean.TRUE)) {
            BlockPos above = this.getBlockPos().above();
            inputItemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, above, (Object)Direction.DOWN);
        }
        if (inputItemHandler != null) {
            for (int i = 0; i < inputItemHandler.getSlots(); ++i) {
                ItemStack stack = inputItemHandler.getStackInSlot(i);
                if (stack.isEmpty() || !ExNihiloAPI.canHammer(stack)) continue;
                ItemStack extractResult = inputItemHandler.extractItem(i, stack.getMaxStackSize(), true);
                ItemStack insertResult = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStackHandler, (ItemStack)extractResult, (boolean)true);
                if (extractResult.getCount() <= insertResult.getCount()) continue;
                int inserted = extractResult.getCount() - insertResult.getCount();
                ItemStack extracted = inputItemHandler.extractItem(i, inserted, false);
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStackHandler, (ItemStack)extracted, (boolean)false);
                return;
            }
        }
    }
}

