/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.sieve;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.permutated.exmachinis.ConfigHolder;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.sieve.FluxSieveBlock;
import net.permutated.exmachinis.util.ItemStackUtil;
import net.permutated.exmachinis.util.WorkStatus;

public class FluxSieveTile
extends AbstractMachineTile {
    public FluxSieveTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FLUX_SIEVE_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    @Override
    protected boolean enableMeshSlot() {
        return true;
    }

    protected boolean isWaterlogged() {
        return (Boolean)this.getBlockState().getValue((Property)FluxSieveBlock.WATERLOGGED);
    }

    protected ItemStackHandler getUpgradeStackHandler() {
        return this.upgradeStackHandler;
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getUpgradeTickDelay())) {
                ItemStack meshStack;
                int quotient;
                Boolean enabled = (Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ENABLED);
                if (Boolean.FALSE.equals(enabled)) {
                    this.workStatus = WorkStatus.REDSTONE_DISABLED;
                    return;
                }
                Direction output = (Direction)this.getBlockState().getValue((Property)AbstractMachineBlock.OUTPUT);
                BlockPos outPos = this.getBlockPos().relative(output);
                IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, outPos, (Object)output.getOpposite());
                if (itemHandler == null || itemHandler.getSlots() == 0) {
                    this.workStatus = WorkStatus.MISSING_INVENTORY;
                    return;
                }
                this.workStatus = WorkStatus.WORKING;
                int cost = this.getUpgradeEnergyCost();
                int stored = this.energyStorage.getEnergyStored();
                int maxProcessed = this.getUpgradeItemsProcessed();
                if (stored < cost) {
                    this.workStatus = WorkStatus.OUT_OF_ENERGY;
                    return;
                }
                if (cost > 0 && (quotient = stored / cost) < maxProcessed) {
                    maxProcessed = quotient;
                }
                if (!ExNihiloAPI.isMeshItem(meshStack = this.upgradeStackHandler.getStackInSlot(1))) {
                    this.workStatus = WorkStatus.MISSING_MESH;
                    return;
                }
                for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    int multiplier;
                    if (maxProcessed == 0) {
                        return;
                    }
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (stack.isEmpty() || !ExNihiloAPI.canSieve(stack, meshStack, this.isWaterlogged())) continue;
                    ItemStack copy = stack.copy();
                    int count = stack.getCount();
                    if (count >= maxProcessed) {
                        multiplier = maxProcessed;
                        copy.shrink(maxProcessed);
                        maxProcessed = 0;
                    } else {
                        multiplier = count;
                        copy = ItemStack.EMPTY;
                        maxProcessed -= count;
                    }
                    int totalCost = cost * multiplier;
                    boolean result = this.energyStorage.consumeEnergy(totalCost, true);
                    if (!result) {
                        this.workStatus = WorkStatus.OUT_OF_ENERGY;
                        return;
                    }
                    this.itemStackHandler.setStackInSlot(i, copy);
                    this.energyStorage.consumeEnergy(totalCost, false);
                    if (Boolean.TRUE.equals(ConfigHolder.SERVER.sieveBulkProcessing.get())) {
                        this.processResults(serverLevel, itemHandler, meshStack, stack, multiplier, false);
                        continue;
                    }
                    this.processResultsSingle(serverLevel, itemHandler, meshStack, stack, multiplier, false);
                }
            }
        }
    }

    private boolean processResults(ServerLevel serverLevel, IItemHandler itemHandler, ItemStack meshStack, ItemStack stack, int multiplier, boolean simulate) {
        ExNihiloAPI.getSieveResult(serverLevel, stack, meshStack, this.isWaterlogged()).stream().map(result -> ItemStackUtil.multiplyStackCount(result, multiplier)).map(output -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate)).forEach(response -> {
            if (!response.isEmpty()) {
                this.workStatus = WorkStatus.INVENTORY_FULL;
            }
        });
        return this.workStatus == WorkStatus.WORKING;
    }

    private boolean processResultsSingle(ServerLevel serverLevel, IItemHandler itemHandler, ItemStack meshStack, ItemStack stack, int multiplier, boolean simulate) {
        for (int i = 0; i < multiplier; ++i) {
            ExNihiloAPI.getSieveResult(serverLevel, stack, meshStack, this.isWaterlogged()).stream().map(output -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate)).forEach(response -> {
                if (!response.isEmpty()) {
                    this.workStatus = WorkStatus.INVENTORY_FULL;
                }
            });
        }
        return this.workStatus == WorkStatus.WORKING;
    }
}

