/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.recipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.permutated.exmachinis.recipes.CompactingRecipe;

public class CompactingRegistry {
    private final Object lock = new Object();
    private List<CompactingRecipe> recipeList = Collections.emptyList();
    private final Map<Item, Optional<CompactingRecipe>> recipeByItemCache = new ConcurrentHashMap<Item, Optional<CompactingRecipe>>();

    public Optional<CompactingRecipe> findRecipe(Item item) {
        return this.recipeByItemCache.computeIfAbsent(item, it -> this.recipeList.stream().filter(recipe -> recipe.getIngredient().test((Item)it)).findFirst());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecipeList(List<RecipeHolder<CompactingRecipe>> recipes) {
        ArrayList<CompactingRecipe> temporary = new ArrayList<CompactingRecipe>(recipes.size());
        recipes.stream().map(RecipeHolder::value).forEach(temporary::add);
        Object object = this.lock;
        synchronized (object) {
            this.recipeList = temporary;
            this.recipeByItemCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompactingRecipe> getRecipeList() {
        Object object = this.lock;
        synchronized (object) {
            return this.recipeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecipes() {
        Object object = this.lock;
        synchronized (object) {
            this.recipeList = Collections.emptyList();
            this.recipeByItemCache.clear();
        }
    }
}

