/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual.features;

import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import oshi.util.tuples.Pair;

public class ConvertBlockFeature
implements IPlaceableFeature {
    public double distance;
    public double chance;
    Function<BlockState, Boolean> convertable;
    Function<BlockState, BlockState> convert;
    Pair<BlockPos, BlockPos> offsets;

    public ConvertBlockFeature(double distance, double chance, Function<BlockState, Boolean> convertable, Function<BlockState, BlockState> convert, Pair<BlockPos, BlockPos> offsets) {
        this.distance = distance;
        this.chance = chance;
        this.convertable = convertable;
        this.convert = convert;
        this.offsets = offsets;
    }

    @Override
    public double distanceFromOthers() {
        return this.distance;
    }

    @Override
    public boolean onPlace(Level level, BlockPos pos, FeaturePlacementRitual placementRitual, RitualBrazierTile brazierTile) {
        BlockState state = level.getBlockState(pos);
        if ((double)level.random.nextFloat() < this.chance && this.convertable.apply(state).booleanValue()) {
            level.setBlockAndUpdate(pos, this.convert.apply(state));
            level.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public String getFeatureName() {
        return "convert_blockstate";
    }

    @Override
    public Pair<BlockPos, BlockPos> getCustomOffsets() {
        return this.offsets;
    }
}

