/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

public class GoToBedState
extends StarbyState {
    public boolean unreachable;
    public BlockPos bedPos;
    public StarbyState nextState;

    public GoToBedState(Starbuncle starbuncle, StarbyTransportBehavior behavior, StarbyState nextState) {
        super(starbuncle, behavior);
        this.nextState = nextState;
        this.bedPos = starbuncle.data.bedPos;
    }

    @Override
    @Nullable
    public StarbyState tick() {
        super.tick();
        if (this.ticksRunning >= 300) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("BedTimeout", "Took too long to find bed"));
            return this.nextState;
        }
        BlockPos bedPos = this.starbuncle.data.bedPos;
        if (bedPos == null) {
            return this.nextState;
        }
        if (this.starbuncle.level.getGameTime() % 10L == 0L) {
            boolean bedValid = this.behavior.isBedValid(bedPos);
            boolean isOnBed = this.behavior.isOnBed();
            if (!bedValid || isOnBed || !this.behavior.canGoToBed()) {
                return this.nextState;
            }
        }
        this.setPath(bedPos.getX(), (double)bedPos.getY() + 1.0, bedPos.getZ(), 1.3);
        this.starbuncle.addGoalDebug(this, new DebugEvent("PathToBed", "Pathing to " + bedPos.getX() + " " + bedPos.getY() + " " + bedPos.getZ()));
        return null;
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.starbuncle.getNavigation().tryMoveToBlockPos(BlockPos.containing((double)x, (double)y, (double)z), 1.3);
        if (this.starbuncle.getNavigation().getPath() != null && !this.starbuncle.getNavigation().getPath().canReach()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("BedUnreachable", "Unreachable"));
            this.unreachable = true;
        }
    }
}

