/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin.camera;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class}, priority=1300)
public abstract class ChunkMapMixin {
    @Shadow
    protected abstract void markChunkPendingToSend(ServerPlayer var1, ChunkPos var2);

    @Shadow
    private static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
    }

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")})
    private void an$onUpdateChunkTracking(ServerPlayer player, CallbackInfo callback) {
        Entity entity = player.getCamera();
        if (entity instanceof ScryerCamera) {
            ScryerCamera camera = (ScryerCamera)entity;
            if (!camera.hasSentChunks()) {
                ChunkTrackingView.difference((ChunkTrackingView)player.getChunkTrackingView(), (ChunkTrackingView)camera.getCameraChunks(), chunkPos -> this.markChunkPendingToSend(player, (ChunkPos)chunkPos), chunkPos -> {});
                camera.setHasSentChunks(true);
            }
        } else if (ScryerCamera.hasRecentlyDismounted((Player)player)) {
            player.getChunkTrackingView().forEach(chunkPos -> this.markChunkPendingToSend(player, (ChunkPos)chunkPos));
        }
    }

    @Inject(method={"onChunkReadyToSend"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getChunkTrackingView()Lnet/minecraft/server/level/ChunkTrackingView;")})
    private void an$sendChunksToCameras(LevelChunk chunk, CallbackInfo callback, @Local ServerPlayer player) {
        ScryerCamera camera;
        Entity entity = player.getCamera();
        if (entity instanceof ScryerCamera && (camera = (ScryerCamera)entity).getCameraChunks().contains(chunk.getPos())) {
            ChunkMapMixin.markChunkPendingToSend(player, chunk);
        }
    }

    @Inject(method={"isChunkTracked"}, at={@At(value="HEAD")}, cancellable=true)
    private void an$onIsChunkTracked(ServerPlayer player, int x, int z, CallbackInfoReturnable<Boolean> callback) {
        ScryerCamera camera;
        Entity entity = player.getCamera();
        if (entity instanceof ScryerCamera && (camera = (ScryerCamera)entity).getCameraChunks().contains(x, z) && !ArsNouveau.immersivePortalsLoaded && !player.connection.chunkSender.isPending(ChunkPos.asLong((int)x, (int)z))) {
            callback.setReturnValue((Object)true);
        }
    }
}

