/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SummonRitualRecipe;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.jetbrains.annotations.Nullable;

public class RitualAnimalSummoning
extends AbstractRitual {
    private final MobCategory category = MobCategory.CREATURE;
    private WeightedRandomList<? extends WeightedEntry> mobs;
    private Optional<RecipeHolder<SummonRitualRecipe>> recipe;

    private Optional<RecipeHolder<SummonRitualRecipe>> getRecipe() {
        return this.getWorld().getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.SUMMON_RITUAL_TYPE.get()).stream().filter(r -> ((SummonRitualRecipe)r.value()).matches(this.getConsumedItems())).findFirst();
    }

    private WeightedRandomList<? extends WeightedEntry> getMobs(Level world) {
        if (this.recipe.isPresent()) {
            SummonRitualRecipe summonRitualRecipe = (SummonRitualRecipe)this.recipe.get().value();
            return summonRitualRecipe.mobs;
        }
        return WeightedRandomList.create(((Biome)world.getBiome(this.getPos()).value()).getMobSettings().getMobs(this.category).unwrap().stream().filter(mob -> !mob.type.is(EntityTags.ANIMAL_SUMMON_BLACKLIST)).collect(Collectors.toList()));
    }

    @Override
    public void onStart(@Nullable Player player) {
        super.onStart(player);
        if (this.tile == null || this.getWorld() == null || this.getPos() == null) {
            return;
        }
        if (this.recipe == null) {
            this.recipe = this.getRecipe();
        }
        this.mobs = this.getMobs(this.getWorld());
    }

    @Override
    protected void tick() {
        Level world = this.getWorld();
        if (world == null || this.getPos() == null) {
            return;
        }
        if (this.recipe == null) {
            this.recipe = this.getRecipe();
        }
        if (this.mobs == null) {
            this.mobs = this.getMobs(world);
        }
        if (world.getGameTime() % 60L == 0L && !world.isClientSide) {
            BlockPos summonPos = this.getPos().above().east(this.rand.nextInt(3) - this.rand.nextInt(6)).north(this.rand.nextInt(3) - this.rand.nextInt(6));
            Optional opt = this.mobs.getRandom(this.rand);
            opt.ifPresent(entry -> {
                if (entry instanceof MobSpawnSettings.SpawnerData) {
                    MobSpawnSettings.SpawnerData spawnerData = (MobSpawnSettings.SpawnerData)entry;
                    Entity mob = spawnerData.type.create(world);
                    if (mob == null) {
                        return;
                    }
                    this.summon(mob, summonPos);
                    this.incrementProgress();
                }
            });
            this.recipe.ifPresentOrElse(recipe -> {
                if (this.getProgress() >= ((SummonRitualRecipe)recipe.value()).count) {
                    this.setFinished();
                }
            }, () -> {
                if (this.getProgress() >= 5) {
                    this.setFinished();
                }
            });
        }
    }

    public void summon(Entity mob, BlockPos pos) {
        mob.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        mob.level().addFreshEntity(mob);
        Level level = mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.players()) {
                serverLevel.sendParticles(player, (ParticleOptions)ParticleTypes.END_ROD, false, (double)pos.getX(), (double)pos.getY() + 0.1, (double)pos.getZ(), 10, 0.1, 0.1, 0.1, 0.05);
            }
        }
    }

    @Override
    public boolean canStart(@Nullable Player player) {
        if (this.getConsumedItems().size() == 0) {
            return true;
        }
        if (this.recipe == null) {
            this.recipe = this.getRecipe();
        }
        return this.recipe.isPresent();
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return this.getWorld().getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.SUMMON_RITUAL_TYPE.get()).stream().anyMatch(r -> ((SummonRitualRecipe)r.value()).augment.test(stack));
    }

    @Override
    public String getLangName() {
        return "Summon Animals";
    }

    @Override
    public String getLangDescription() {
        return "Summon a random variety of wild animals native to the biome it's in.";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.ANIMAL_SUMMON);
    }
}

