/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RitualOvergrowth
extends AbstractRitual {
    @Override
    protected void tick() {
        Level world = this.getWorld();
        BlockPos pos = this.getPos();
        if (this.getWorld().isClientSide) {
            ParticleUtil.spawnRitualAreaEffect(this.getPos(), this.getWorld(), this.rand, this.getCenterColor(), 5);
        } else {
            if (this.getWorld().getGameTime() % 200L != 0L) {
                return;
            }
            if (this.isAnimalGrowth()) {
                List animals = this.getWorld().getEntitiesOfClass(AgeableMob.class, new AABB(this.getPos()).inflate(5.0));
                boolean didWorkOnce = false;
                for (AgeableMob a : animals) {
                    if (!a.isBaby()) continue;
                    a.ageUp(500, true);
                    didWorkOnce = true;
                }
                if (didWorkOnce) {
                    this.setNeedsSource(true);
                }
            } else {
                int range = 5;
                boolean didWorkOnce = false;
                for (BlockPos b : BlockPos.betweenClosed((BlockPos)pos.offset(range, -1, range), (BlockPos)pos.offset(-range, 1, -range))) {
                    BlockState state = world.getBlockState(b);
                    if (state.getBlock() instanceof FarmBlock || world.getBlockState(b.above()).getBlock() instanceof BonemealableBlock) {
                        b = b.above();
                        state = world.getBlockState(b);
                    }
                    if (this.rand.nextInt(25) != 0 || !BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)world, (BlockPos)b, (Player)ANFakePlayer.getPlayer((ServerLevel)world))) continue;
                    didWorkOnce = true;
                }
                if (didWorkOnce) {
                    this.setNeedsSource(true);
                }
            }
        }
    }

    public boolean isAnimalGrowth() {
        return this.didConsumeItem((ItemLike)Items.BONE_BLOCK);
    }

    @Override
    public int getSourceCost() {
        return 500;
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return this.getConsumedItems().isEmpty() && stack.getItem() == Items.BONE_BLOCK;
    }

    @Override
    public String getLangName() {
        return "Overgrowth";
    }

    @Override
    public String getLangDescription() {
        return "Occasionally bone meals blocks in the area around it. This ritual requires source to operate. If augmented with a Bone Block, this ritual will instead force baby animals to grow faster.";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.OVERGROWTH);
    }

    @Override
    public ParticleColor getCenterColor() {
        return ParticleColor.makeRandomColor(20, 255, 20, this.rand);
    }
}

