/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.potion.BlackFlameEyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BlackFireBlock
extends BlockBase {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)15);
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty UPPER = BooleanProperty.create((String)"up");
    public static final Random RNG = new Random();
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(facingProperty -> facingProperty.getKey() != Direction.DOWN).collect(Util.toMap());

    protected BlackFireBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FIRE).noCollission().noLootTable().randomTicks().strength(0.0f).lightLevel(state -> 15).sound(SoundType.WOOL), "black_fire");
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForPlacement((LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState getStateForPlacement(LevelAccessor blockReader, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = blockReader.getBlockState(blockpos);
        if (!this.canCatchFire(blockReader, pos, Direction.UP) && !Block.canSupportRigidBlock((BlockGetter)blockReader, (BlockPos)blockpos)) {
            BlockState blockstate1 = this.defaultBlockState();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(blockReader, pos.relative(direction), direction.getOpposite())));
            }
            return blockstate1;
        }
        return this.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return worldIn.getBlockState(blockpos).isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable(worldIn, pos);
    }

    private boolean areNeighborsFlammable(LevelAccessor worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.relative(direction), direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.isClientSide) {
            worldIn.scheduleTick(pos, state.getBlock(), 6);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource p_60554_) {
        int i = (Integer)state.getValue((Property)AGE);
        this.tick(state, level, pos, p_60554_);
        if (i < 15) {
            state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
        } else {
            level.removeBlock(pos, false);
        }
        super.randomTick(state, level, pos, p_60554_);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        worldIn.scheduleTick(pos, state.getBlock(), 20);
        if (worldIn != null && (worldIn.isRaining() || worldIn.getLevelData().isRaining())) {
            worldIn.removeBlock(pos, false);
        }
        if (ServerHandler.tickCounter % (long)MTConfig.BLACK_FLAME_UPDATE_TICKS == 0L) {
            if (worldIn.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
                if (!worldIn.isAreaLoaded(pos, 2)) {
                    return;
                }
                if (!this.canPlaceBlockAt((Level)worldIn, pos)) {
                    worldIn.removeBlock(pos, false);
                }
                Block block = worldIn.getBlockState(pos.below()).getBlock();
                if (Utils.isBlockAir((Level)worldIn, pos.below()) || block == ModBlocks.blackFireBlock.get()) {
                    worldIn.removeBlock(pos, false);
                    return;
                }
                int i = (Integer)state.getValue((Property)AGE);
                state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                if (i >= MTConfig.BLACK_FLAME_DEATH_AGE && worldIn.getBlockState(pos.below()).getBlock() != Blocks.NETHERRACK) {
                    worldIn.removeBlock(pos, false);
                    return;
                }
                if (this.canDie((Level)worldIn, pos)) {
                    worldIn.removeBlock(pos, false);
                } else {
                    if (i < 15) {
                        state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                        worldIn.setBlock(pos, state, 4);
                    }
                    if (!this.canNeighborCatchFire((Level)worldIn, pos)) {
                        if (!worldIn.getBlockState(pos.below()).isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP) || i > 3) {
                            worldIn.removeBlock(pos, false);
                        }
                        return;
                    }
                    if (!this.canCatchFire((LevelAccessor)worldIn, pos.below(), Direction.UP) && i == 15 && rand.nextInt(4) == 0) {
                        worldIn.removeBlock(pos, false);
                        return;
                    }
                }
            } else {
                worldIn.removeBlock(pos, false);
            }
        }
    }

    protected boolean canDie(Level worldIn, BlockPos pos) {
        return worldIn.isRaining();
    }

    @Deprecated
    public int getFlammability(Block blockIn) {
        return 50 + RNG.nextInt(20);
    }

    @Deprecated
    public int getEncouragement(Block blockIn) {
        return 50 + RNG.nextInt(20);
    }

    private boolean canNeighborCatchFire(Level worldIn, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!this.canCatchFire((LevelAccessor)worldIn, pos.relative(enumfacing), enumfacing.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public void entityInside(BlockState p_60495_, Level p_60496_, BlockPos p_60497_, Entity entity) {
        if (entity instanceof LivingEntity) {
            EffectUtil.buff((LivingEntity)entity, ModEffects.BLACK_BURNING, false, 180);
            BlackFlameEyesPotion.notifyIfBurning((LivingEntity)entity);
        }
    }

    @Deprecated
    public boolean canCatchFire(LevelAccessor worldIn, BlockPos pos) {
        return this.canCatchFire(worldIn, pos, Direction.UP);
    }

    public boolean canPlaceBlockAt(Level worldIn, BlockPos pos) {
        return this.canNeighborCatchFire(worldIn, pos);
    }

    public boolean canCatchFire(LevelAccessor world, BlockPos pos, Direction face) {
        Block b = world.getBlockState(pos).getBlock();
        BlockEntity te = world.getBlockEntity(pos);
        return te == null && b != ModBlocks.invisibleBarrierBlock.get() && !EffectUtil.unchangableBlock(b, Arrays.asList(Blocks.AIR, Blocks.ICE, Blocks.SNOW, Blocks.WATER, Blocks.LAVA, Blocks.CAVE_AIR, Blocks.VOID_AIR, (Block)ModBlocks.blackFireBlock.get()));
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return true;
    }
}

