/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.enchant.MahoujinProjectorEnchant;
import stepsword.mahoutsukai.networking.ProjectorRightClickPacket;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class MahoujinProjector
extends BlockTileEntity<MahoujinProjectorTileEntity> {
    public static final AABB boundingBox = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AABB boundingBoxE = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public MahoujinProjector() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).noOcclusion(), "mahoujin_projector");
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide && !player.getMainHandItem().is(Items.STICK)) {
            MahouTsukaiMod.proxy.openProjectorGUI(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public static void shiftRCBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState b;
        if (event.getItemStack().getItem() == Items.STICK && (b = event.getLevel().getBlockState(event.getHitVec().getBlockPos())).is(ModBlocks.projector) && event.getEntity().isDiscrete()) {
            b.useItemOn(event.getItemStack(), event.getLevel(), event.getEntity(), event.getHand(), event.getHitVec());
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.getBlockEntity(pos) instanceof MahoujinProjectorTileEntity) {
            if (level.isClientSide && MahouTsukaiMod.proxy.projectorArmorClick(player, pos)) {
                return ItemInteractionResult.SUCCESS;
            }
            MahoujinProjectorTileEntity te = (MahoujinProjectorTileEntity)level.getBlockEntity(pos);
            if (!level.isClientSide && stack.getItem() == Items.STICK && te != null) {
                if (player.isDiscrete()) {
                    if (MahoujinProjectorTileEntity.canEdit(player, te) && Utils.hasProjectorEnchant(stack)) {
                        List<ProjectorValues> pvs = Utils.getProjectorEnchant(stack).getPv();
                        if (!pvs.isEmpty()) {
                            ProjectorValues pv;
                            te.pv = pv = pvs.getFirst();
                            te.sendUpdates();
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    MahoujinProjectorEnchant.setProjectorNBT(player.getMainHandItem(), te, ProjectorRightClickPacket.ARMOR_ACTION.REPLACE);
                    return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public Class<MahoujinProjectorTileEntity> getTileEntityClass() {
        return MahoujinProjectorTileEntity.class;
    }

    @javax.annotation.Nullable
    public MahoujinProjectorTileEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MahoujinProjectorTileEntity(blockPos, blockState);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MahoujinProjectorTileEntity) {
                MahoujinProjectorTileEntity mte = (MahoujinProjectorTileEntity)blockEntity;
                mte.caster = player.getUUID();
                mte.sendUpdates();
            }
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }
}

