/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.spells;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import stepsword.mahoutsukai.block.spells.MahoujinBlockTileEntity;
import stepsword.mahoutsukai.datacomponents.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ScrollGiver;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class SingleUseMahoujinBlockTileEntity<T extends MahoujinTileEntity>
extends MahoujinBlockTileEntity<T> {
    public SingleUseMahoujinBlockTileEntity(String name) {
        super(name);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState state2, boolean v1) {
        if (!world.isClientSide) {
            BlockEntity te = world.getBlockEntity(pos);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (te instanceof ScrollGiver) {
                ItemStack stack;
                MahoujinTileEntity mte;
                ScrollGiver sg = (ScrollGiver)te;
                if (te instanceof MahoujinTileEntity && (mte = (MahoujinTileEntity)te).hasCloth() && (stack = sg.getItemToGive()) != null && stack.getItem() instanceof SpellScroll) {
                    stack.setCount(1);
                    ScrollMahou mahou = Utils.getScrollMahou(stack);
                    if (mte.isFay()) {
                        mahou.setCasterUUID(FaeEssence.faeID);
                        mahou.setCasterName("The Fae");
                    } else if (mte.getCaster() != null) {
                        mahou.setCasterUUID(mte.getCaster().getUUID());
                        mahou.setCasterName(mte.getCaster().getDisplayName().getString());
                    }
                    Utils.setScrollMahou(stack, mahou);
                    drops.add(stack);
                }
            }
            drops.forEach(a -> SingleUseMahoujinBlockTileEntity.popResource((Level)world, (BlockPos)pos, (ItemStack)a));
        }
        super.onRemove(state, world, pos, state2, v1);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity te;
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof ScrollGiver) {
            MahoujinTileEntity mte;
            ScrollGiver sg = (ScrollGiver)te;
            if (te instanceof MahoujinTileEntity && (mte = (MahoujinTileEntity)te).hasCloth()) {
                world.setBlockAndUpdate(pos, EffectUtil.AIR);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

