/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MorganBallEntity
extends Entity {
    private static final String TAG_SPHERE_SIZE = "MAHOUTSUKAI_SPHERE_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_SPIKE_LENGTH = "MAHOUTSUKAI_SPIKE_LENGTH";
    private static final String TAG_TARGETS = "MAHOUTSUKAI_TARGETS";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> SPHERE_SIZE = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SPIKE_LENGTH = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<CompoundTag> TARGETS = SynchedEntityData.defineId(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public LivingEntity caster;
    public float damage;
    public int dyingTicks = 0;
    public float prev_spike_len;
    public float prev_sphere_size;
    ArrayList<LivingEntity> targets;
    public ArrayList<Float> yaws;
    public ArrayList<Float> pitchs;
    public ArrayList<Float> ds;
    public boolean nocaster = false;
    public Vec3 origPos;
    public int m = 0;
    public int earlydeath = 0;
    public float rate = 0.4f;
    public static final String entityName = "morgan_ball_entity";
    public float maxsize = 1.3f;

    public MorganBallEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MorganBallEntity(Level world) {
        super((EntityType)ModEntities.MORGAN_BALL.get(), world);
        this.noCulling = true;
    }

    public MorganBallEntity(Level world, LivingEntity c, float r, float g, float b, float a, float r2, float g2, float b2, float size, float damage) {
        this(world);
        this.setColor(r, g, b, a, r2, g2, b2);
        this.sizer(size);
        if (c == null) {
            this.nocaster = true;
        } else {
            this.caster = c;
        }
        this.damage = damage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPHERE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(1.0f));
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
        builder.define(SPIKE_LENGTH, (Object)Float.valueOf(0.0f));
        builder.define(TARGETS, (Object)new CompoundTag());
    }

    public void tick() {
        block32: {
            block29: {
                block30: {
                    block31: {
                        this.xo = this.getX();
                        this.yo = this.getY();
                        this.zo = this.getZ();
                        Vec3 newpos = this.position().add(this.getDeltaMovement());
                        BlockPos pos = Utils.toBlockPos(newpos.add(this.getDeltaMovement().scale((double)this.getSphereSize())));
                        if (this.level().getBlockState(pos).isAir()) {
                            this.teleportTo(newpos.x, newpos.y, newpos.z);
                        }
                        if (this.level().isClientSide) break block29;
                        if (!(this.nocaster || this.caster != null && this.caster.getMainHandItem().getItem() instanceof Morgan)) {
                            this.discard();
                            return;
                        }
                        if ((!this.nocaster || this.dyingTicks >= 10) && (this.nocaster || this.dyingTicks > 0)) break block30;
                        if (this.earlydeath > 0) {
                            this.setSphereSize(this.getSphereSize() - 0.04f);
                            if (this.getSphereSize() <= 0.0f) {
                                this.discard();
                            }
                        } else {
                            this.setSphereSize(Math.min(this.maxsize, this.getSphereSize() + 0.02f));
                        }
                        if (this.nocaster && this.origPos != null) {
                            if (this.position().distanceToSqr(this.origPos) > (double)((MTConfig.MORGAN_MAX_BALL_RANGE - 1) * (MTConfig.MORGAN_MAX_BALL_RANGE - 1))) {
                                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.3f));
                            } else {
                                this.setDeltaMovement(this.getDeltaMovement().scale((double)1.02f));
                            }
                        } else if (this.position().distanceToSqr(this.caster.position()) > (double)(MTConfig.MORGAN_MAX_BALL_RANGE * MTConfig.MORGAN_MAX_BALL_RANGE)) {
                            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.3f));
                        } else {
                            this.setDeltaMovement(this.getDeltaMovement().scale((double)1.02f));
                        }
                        if (!this.nocaster) break block31;
                        if (this.getSphereSize() > 1.0f && this.earlydeath <= 0) {
                            ++this.dyingTicks;
                        }
                        break block32;
                    }
                    if (!(this.caster.getMainHandItem().getItem() instanceof Morgan) || this.caster.getUseItem().getItem() instanceof Morgan) break block32;
                    if (this.getSphereSize() > 1.0f && this.earlydeath <= 0) {
                        ++this.dyingTicks;
                    } else {
                        ++this.earlydeath;
                    }
                    break block32;
                }
                if (this.nocaster) {
                    this.setDeltaMovement(this.getDeltaMovement().scale((double)0.3f));
                }
                if (this.targets == null) {
                    int radius = MTConfig.MORGAN_SPIKE_RANGE;
                    AABB aabb = new AABB(this.getX() - (double)radius, this.getY() - (double)radius, this.getZ() - (double)radius, this.getX() + (double)radius, this.getY() + (double)radius, this.getZ() + (double)radius);
                    List ts = this.level().getEntitiesOfClass(LivingEntity.class, aabb, a -> this.nocaster || !a.equals((Object)this.caster));
                    this.targets = new ArrayList();
                    this.targets.addAll(ts);
                    this.setDataTargets(this.setTargets(this.targets));
                } else if (this.m > 6) {
                    this.setSpikeLength(Math.max(0.0f, this.getSpikeLength() - this.rate));
                    if (this.getSpikeLength() == 0.0f) {
                        ++this.earlydeath;
                    }
                    if (this.earlydeath > 0) {
                        this.setSphereSize(this.getSphereSize() - 0.04f);
                        if (this.getSphereSize() <= 0.0f) {
                            this.discard();
                        }
                    }
                    if (this.m == 7) {
                        ArrayList<LivingEntity> spikeTargets = this.getTargets(this.getDataTargets());
                        for (LivingEntity s : spikeTargets) {
                            if (!this.nocaster && ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.caster.getUUID(), (Entity)s)) continue;
                            if (this.nocaster) {
                                EffectUtil.magicAttack(s, this.damage / (float)spikeTargets.size(), null);
                            } else {
                                EffectUtil.magicAttack(s, this.damage / (float)spikeTargets.size(), this.caster);
                            }
                            Vec3 d = s.getEyePosition(1.0f).subtract(this.position());
                            MorganBallEntity.boop((Entity)s, (float)d.length() / 4.0f, d.x, d.y, d.z);
                        }
                    }
                    ++this.m;
                } else if (this.getSpikeLength() >= 1.0f) {
                    ++this.m;
                } else {
                    this.setSpikeLength(this.getSpikeLength() + this.rate);
                }
                ++this.dyingTicks;
                break block32;
            }
            ArrayList<LivingEntity> spikeTargets = this.getTargets(this.getDataTargets());
            this.yaws = new ArrayList();
            this.pitchs = new ArrayList();
            this.ds = new ArrayList();
            for (LivingEntity e : spikeTargets) {
                this.addYawPitchDist(e);
            }
        }
        this.prev_spike_len = this.getSpikeLength();
        this.prev_sphere_size = this.getSphereSize();
    }

    public void addYawPitchDist(LivingEntity e) {
        if (e != null) {
            Vec3 v = e.getEyePosition(1.0f).subtract(this.position());
            float d = (float)v.length() + 1.5f;
            v = v.normalize();
            float pitch = (float)Math.asin(-v.y);
            float yaw = (float)Math.atan2(v.x, v.z);
            this.yaws.add(Float.valueOf(EffectUtil.toDegrees(yaw)));
            this.pitchs.add(Float.valueOf(EffectUtil.toDegrees(pitch) + 90.0f));
            this.ds.add(Float.valueOf(d));
        }
    }

    public boolean isPickable() {
        return false;
    }

    public void playerTouch(Player entityIn) {
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue()};
    }

    protected void checkInsideBlocks() {
    }

    @Nullable
    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public void sizer(float s) {
        this.setSphereSize(s);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setSphereSize(compound.getFloat(TAG_SPHERE_SIZE));
        this.setSpikeLength(compound.getFloat(TAG_SPIKE_LENGTH));
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A), compound.getFloat(TAG_COLOR_R2), compound.getFloat(TAG_COLOR_G2), compound.getFloat(TAG_COLOR_B2));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
        this.setDataTargets(compound.getCompound(TAG_TARGETS));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_SPHERE_SIZE, this.getSphereSize());
        compound.putFloat(TAG_SPIKE_LENGTH, this.getSpikeLength());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_COLOR_R2, colors[4]);
        compound.putFloat(TAG_COLOR_G2, colors[5]);
        compound.putFloat(TAG_COLOR_B2, colors[6]);
        compound.putFloat(TAG_DISTANCE, this.getDistance());
        compound.put(TAG_TARGETS, (Tag)this.getDataTargets());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public float getSphereSize() {
        return ((Float)this.entityData.get(SPHERE_SIZE)).floatValue();
    }

    public void setSphereSize(float s) {
        this.entityData.set(SPHERE_SIZE, (Object)Float.valueOf(s));
    }

    public float getSpikeLength() {
        return ((Float)this.entityData.get(SPIKE_LENGTH)).floatValue();
    }

    public void setSpikeLength(float s) {
        this.entityData.set(SPIKE_LENGTH, (Object)Float.valueOf(s));
    }

    public ArrayList<LivingEntity> getTargets(CompoundTag nbt) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        if (nbt != null) {
            int k = 0;
            while (nbt.contains("target" + k)) {
                Entity e = this.level().getEntity(nbt.getInt("target" + k));
                if (e instanceof LivingEntity) {
                    lst.add((LivingEntity)e);
                }
                ++k;
            }
        }
        return lst;
    }

    public CompoundTag setTargets(ArrayList<LivingEntity> targets) {
        CompoundTag nbt = new CompoundTag();
        for (int k = 0; k < targets.size(); ++k) {
            if (!targets.get(k).isAlive()) continue;
            nbt.putInt("target" + k, targets.get(k).getId());
        }
        return nbt;
    }

    public CompoundTag getDataTargets() {
        return (CompoundTag)this.entityData.get(TARGETS);
    }

    public void setDataTargets(CompoundTag nbt) {
        this.entityData.set(TARGETS, (Object)nbt);
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.hasImpulse = true;
        float f = Mth.sqrt((float)((float)(x * x + z * z + y * y)));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.hurtMarked = true;
        if (entity.onGround()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.6) {
                motionY = 0.6;
            }
        }
        entity.setDeltaMovement(new Vec3(motionX, motionY, motionZ));
    }
}

