/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class ParticleSphereExplosion
extends Particle {
    private static final ResourceLocation beam = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");
    public String loc;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public float[] rgba = new float[8];
    public float rotation = 0.0f;
    public float sz = 0.2f;
    public boolean shaders = false;
    public int image;
    public float speed = 0.0f;
    public float lastRadius = 0.0f;
    public float radius = 0.0f;
    public float maxRadius = 4.0f;
    public boolean destroy = false;
    public int quality = MTConfig.EXPLOSION_PARTICLE_QUALITY;
    public int delay = 0;
    public int delay2 = 0;

    public ParticleSphereExplosion(ClientLevel worldIn, float[] colors, double xCoordIn, double yCoordIn, double zCoordIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.bCol = 1.0f;
        this.alpha = 0.4f;
        float maxAge = 30.0f;
        this.lifetime = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.lifetime = (int)((float)this.lifetime);
        this.rgba = colors;
        this.image = this.random.nextInt(6) + 1;
    }

    public void addDelay(int delay) {
        this.delay += delay;
        this.lifetime += delay;
    }

    public void addDelay2(int delay2) {
        this.delay2 += delay2;
        this.lifetime += delay2;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (this.delay > 0) {
            --this.delay;
        } else {
            this.oRoll = this.roll;
            this.speed = (this.maxRadius - this.radius) * 1.0f / 3.0f;
            if (!this.destroy && this.speed < 0.02f) {
                this.destroy = true;
            }
            if (this.destroy) {
                if (this.delay2 > 0) {
                    --this.delay2;
                } else {
                    this.speed = -this.maxRadius / 3.0f;
                }
            }
            this.lastRadius = this.radius;
            this.radius = Mth.clamp((float)(this.radius + this.speed), (float)0.0f, (float)this.maxRadius);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }

    public void render(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public static void renderParticleSphereExplosion(ParticleSphereExplosion particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        double d0 = particle.xo + (particle.x - particle.xo) * (double)partialTicks;
        double d1 = particle.yo + (particle.y - particle.yo) * (double)partialTicks;
        double d2 = particle.zo + (particle.z - particle.zo) * (double)partialTicks;
        matrix.pushPose();
        matrix.translate(d0 - d3, d1 - d4, d2 - d5);
        RenderUtils.rotateQ(particle.yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(particle.pitch, 1.0f, 0.0f, 0.0f, matrix);
        matrix.scale(particle.sz, particle.sz, particle.sz);
        float r = particle.rgba[0];
        float g = particle.rgba[1];
        float b = particle.rgba[2];
        float a = particle.rgba[3];
        float r2 = particle.rgba[4];
        float g2 = particle.rgba[5];
        float b2 = particle.rgba[6];
        float a2 = particle.rgba[7];
        int j = 240;
        int k = 240;
        float xx = 0.5f;
        float bxx = -xx;
        float yy = 0.0f;
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        Matrix4f m = matrix.last().pose();
        RenderType sphereType = MahoujinRenderType.wrapBlendLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(beam, 1)));
        RenderType sphereType2 = MahoujinRenderType.wrapBlendLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(beam, 2)));
        float realage = partialTicks + (float)particle.age;
        float progress = realage / (float)particle.lifetime;
        float realRadius = particle.lastRadius + partialTicks * (particle.radius - particle.lastRadius);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, realRadius * (0.9f + 0.07f * progress), particle.quality, j, k, r2, g2, b2, a2, sphereType2);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, realRadius, particle.quality, j, k, r, g, b, 0.2f, sphereType);
        matrix.popPose();
    }

    public static float calculateSize(float progress) {
        float p = progress * 2.2f;
        return (float)Math.max(0.0, -1.0 * Math.pow(p - 1.2f, 12.0) + 3.0);
    }
}

