/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.entity;

import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.util.RecipeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.yxiao233.ifeu.api.block.entity.IFEUFluidFuelGeneratorEntity;
import net.yxiao233.ifeu.api.recipe.FluidGeneratorSerializableRecipe;
import net.yxiao233.ifeu.common.utils.FluidTankElementsUtil;

public abstract class IFEUFluidFuelJsonGeneratorEntity<T extends IFEUFluidFuelJsonGeneratorEntity<T>>
extends IFEUFluidFuelGeneratorEntity<T> {
    private FluidGeneratorSerializableRecipe recipe;

    public IFEUFluidFuelJsonGeneratorEntity(BlockWithTile blockWithTile, BlockPos blockPos, BlockState blockState) {
        super(blockWithTile, blockPos, blockState);
    }

    public abstract <R extends FluidGeneratorSerializableRecipe> RecipeType<R> setRecipeType();

    @Override
    public FluidTankElementsUtil getFluidTankElements() {
        return new FluidTankElementsUtil();
    }

    @Override
    public FluidStack getConsumeFuel() {
        return FluidStack.EMPTY;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.checkForRecipe();
    }

    @Override
    public int consumeFuel() {
        if (this.recipe != null && this.extraStartCondition()) {
            FluidStack stack = this.recipe.inputFluid;
            if (this.inputFluid.getFluid().is(stack.getFluid()) && this.inputFluid.getFluid().getAmount() >= stack.getAmount()) {
                this.inputFluid.drainForced(stack, IFluidHandler.FluidAction.EXECUTE);
                return this.recipe.progressTime;
            }
        } else {
            this.checkForRecipe();
        }
        return 0;
    }

    @Override
    public boolean canStart() {
        if (this.recipe != null && this.extraStartCondition()) {
            FluidStack stack = this.recipe.inputFluid;
            return this.inputFluid.getFluid().is(stack.getFluid()) && this.inputFluid.getFluid().getAmount() >= stack.getAmount() && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored();
        }
        this.checkForRecipe();
        return false;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.recipe != null && this.recipe.matches((IFluidHandler)this.inputFluid, this.getEnergyStorage())) {
                return;
            }
            this.recipe = RecipeUtil.getRecipes((Level)this.level, this.setRecipeType()).stream().filter(recipe -> recipe.matches((IFluidHandler)this.inputFluid, this.getEnergyStorage())).findFirst().orElse(null);
        }
    }

    public void setChanged() {
        super.setChanged();
        this.checkForRecipe();
    }

    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        this.checkForRecipe();
    }
}

