/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.entity;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.module.BlockWithTile;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.yxiao233.ifeu.api.block.entity.BetterIndustrialGeneratorTile;
import net.yxiao233.ifeu.common.utils.SlotElementsUtil;

public abstract class IFEUItemFuelGeneratorEntity<T extends IFEUItemFuelGeneratorEntity<T>>
extends BetterIndustrialGeneratorTile<T> {
    public int getPowerPerTick;
    public int getExtractionRate;
    public int getMaxProgress;
    public int getMaxStoredPower;
    @Save
    public SidedInventoryComponent<T> input;

    public IFEUItemFuelGeneratorEntity(BlockWithTile blockWithTile, BlockPos blockPos, BlockState blockState) {
        super(blockWithTile, blockPos, blockState);
        this.init();
    }

    public abstract SlotElementsUtil getSlotElements();

    public abstract Class<?> getGeneratorConfigClass();

    public abstract ItemStack getConsumeFuel();

    public void init() {
        int maxStoredPower;
        int maxProgress;
        int extractionRate;
        int powerPerTick;
        SlotElementsUtil util = this.getSlotElements();
        this.input = (SidedInventoryComponent)new SidedInventoryComponent(util.getId(), util.getXPos(), util.getYPos(), util.getSize(), util.getPosition()).setColor(util.getColor()).setRange(util.getRange()[0], util.getRange()[1]).setOutputFilter(util.getOutputFilter()).setInputFilter(util.getInputFilter()).setComponentHarness((IComponentHarness)((IFEUItemFuelGeneratorEntity)this.getSelf()));
        this.addInventory((InventoryComponent)this.input);
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field1 = clazz.getField("powerPerTick");
            Field field2 = clazz.getField("extractionRate");
            Field field3 = clazz.getField("maxProgress");
            Field field4 = clazz.getField("maxStoredPower");
            powerPerTick = field1.getInt(field1.getName());
            extractionRate = field2.getInt(field2.getName());
            maxProgress = field3.getInt(field3.getName());
            maxStoredPower = field4.getInt(field4.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.getPowerPerTick = powerPerTick;
        this.getExtractionRate = extractionRate;
        this.getMaxProgress = maxProgress;
        this.getMaxStoredPower = maxStoredPower;
    }

    @Override
    public int consumeFuel() {
        ItemStack stack = this.getConsumeFuel();
        if (stack == null || stack == ItemStack.EMPTY) {
            return 0;
        }
        if (this.input.getStackInSlot(0).is(stack.getItem()) && this.input.getStackInSlot(0).getCount() >= stack.getCount()) {
            this.input.extractItem(0, stack.getCount(), false);
            return this.getMaxProgress;
        }
        return 0;
    }

    @Override
    public boolean canStart() {
        return this.input.getStackInSlot(0).getCount() >= this.getConsumeFuel().getCount() && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored();
    }

    @Override
    public int getEnergyProducedEveryTick() {
        int powerPerTick;
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field4 = clazz.getField("powerPerTick");
            powerPerTick = field4.getInt(field4.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return powerPerTick;
    }

    @Override
    public ProgressBarComponent<T> getProgressBar() {
        return new ProgressBarComponent(30, 20, 0, 15).setComponentHarness((IComponentHarness)((IFEUItemFuelGeneratorEntity)this.getSelf())).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
    }

    @Override
    public int getEnergyCapacity() {
        int maxStoredPower;
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field4 = clazz.getField("maxStoredPower");
            maxStoredPower = field4.getInt(field4.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return maxStoredPower;
    }

    @Override
    public int getExtractingEnergy() {
        int extractionRate;
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field4 = clazz.getField("extractionRate");
            extractionRate = field4.getInt(field4.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return extractionRate;
    }
}

