/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.entity;

import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.yxiao233.ifeu.api.block.entity.IFEUItemFuelGeneratorEntity;
import net.yxiao233.ifeu.api.recipe.ItemGeneratorSerializableRecipe;
import net.yxiao233.ifeu.common.utils.SlotElementsUtil;

public abstract class IFEUItemFuelJsonGeneratorEntity<T extends IFEUItemFuelJsonGeneratorEntity<T>>
extends IFEUItemFuelGeneratorEntity<T> {
    private ItemGeneratorSerializableRecipe recipe;

    public IFEUItemFuelJsonGeneratorEntity(BlockWithTile blockWithTile, BlockPos blockPos, BlockState blockState) {
        super(blockWithTile, blockPos, blockState);
    }

    public abstract <R extends ItemGeneratorSerializableRecipe> RecipeType<R> setRecipeType();

    @Override
    public SlotElementsUtil getSlotElements() {
        List list = RecipeUtil.getRecipes((Level)this.level, this.setRecipeType());
        ArrayList stacks = new ArrayList(list.size());
        list.forEach(recipe -> stacks.add(recipe.input));
        return new SlotElementsUtil().setInputFilter((stack, integer) -> stacks.contains(stack));
    }

    @Override
    public ItemStack getConsumeFuel() {
        return ItemStack.EMPTY;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.checkForRecipe();
    }

    @Override
    public int consumeFuel() {
        if (this.recipe != null) {
            ItemStack stack = this.recipe.input;
            if (this.input.getStackInSlot(0).getCount() >= stack.getCount()) {
                this.input.extractItem(0, stack.getCount(), false);
                return this.recipe.progressTime;
            }
        } else {
            this.checkForRecipe();
        }
        return 0;
    }

    @Override
    public boolean canStart() {
        if (this.recipe != null) {
            return this.input.getStackInSlot(0).getCount() >= this.recipe.input.getCount() && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored();
        }
        this.checkForRecipe();
        return false;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.recipe != null && this.recipe.matches((IItemHandler)this.input, this.getEnergyStorage())) {
                return;
            }
            this.recipe = RecipeUtil.getRecipes((Level)this.level, this.setRecipeType()).stream().filter(recipe -> recipe.matches((IItemHandler)this.input, this.getEnergyStorage())).findFirst().orElse(null);
        }
    }

    public void setChanged() {
        super.setChanged();
        this.checkForRecipe();
    }

    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        this.checkForRecipe();
    }
}

