/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.yxiao233.ifeu.api.block.entity.IFEUStructureProcessingTile;
import net.yxiao233.ifeu.api.structure.MultiBlockStructure;
import net.yxiao233.ifeu.common.utils.RendererProvider;
import org.apache.commons.lang3.tuple.Pair;

public class IFEUStructureEntityRenderer
implements BlockEntityRenderer<IFEUStructureProcessingTile<?>> {
    private volatile MultiBlockStructure structure;
    private final int tick = 200;

    public IFEUStructureEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(IFEUStructureProcessingTile<?> entity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        if (entity.isShouldRenderer() && entity.direction != null) {
            Level level = entity.getLevel();
            if (level == null) {
                return;
            }
            this.structure = this.getStructure(entity);
            Direction direction = entity.direction;
            BlockPos machinePos = entity.getBlockPos();
            boolean renderFull = entity.renderFull;
            entity.increaseTime(1);
            Pair<List<Pair<BlockPos, Block>>, List<Pair<BlockPos, Pair<List<Block>, TagKey<Block>>>>> poses = this.structure.getRenderStructure(direction, machinePos);
            RendererProvider provider = new RendererProvider(poseStack, multiBufferSource, machinePos);
            int minY = this.structure.getShouldRenderMinY(level, direction, machinePos);
            ((List)poses.getLeft()).forEach(pair -> {
                BlockPos pos = (BlockPos)pair.getLeft();
                BlockState state = ((Block)pair.getRight()).defaultBlockState();
                this.render(pos, state, provider, minY, !level.getBlockState(pos).is((Block)pair.getRight()), renderFull);
            });
            ((List)poses.getRight()).forEach(pair -> {
                int index;
                BlockPos pos = (BlockPos)pair.getLeft();
                List blocks = (List)((Pair)pair.getRight()).getLeft();
                for (index = (int)Math.floor((double)entity.getTime() / 200.0); index >= blocks.size(); index -= blocks.size()) {
                }
                if (index < 0) {
                    index = 0;
                }
                BlockState state = ((Block)blocks.get(index)).defaultBlockState();
                this.render(pos, state, provider, minY, !level.getBlockState(pos).is((TagKey)((Pair)pair.getRight()).getRight()), renderFull);
            });
        }
    }

    private void render(BlockPos pos, BlockState state, RendererProvider provider, int minY, boolean shouldRender, boolean renderFull) {
        if (shouldRender) {
            if (renderFull) {
                provider.renderSingleBatchedGhostBlock(pos, state);
            } else if (pos.getY() != minY) {
                boolean bl = false;
            } else {
                provider.renderSingleBatchedGhostBlock(pos, state);
            }
        }
    }

    public MultiBlockStructure getStructure(IFEUStructureProcessingTile<?> entity) {
        if (this.structure == null) {
            return entity.multiBlockStructure();
        }
        return this.structure;
    }
}

