/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.renderer;

import com.hrznstudio.titanium.block.RotatableBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.yxiao233.ifeu.api.structure.MultiBlockStructure;
import net.yxiao233.ifeu.common.utils.RendererProvider;
import org.apache.commons.lang3.tuple.Pair;

public class IFEUStructureEntityRendererJS
implements BlockEntityRenderer<BlockEntity> {
    private final MultiBlockStructure structure;
    private final int tick = 200;
    private final Item item;
    private int time = 0;

    public IFEUStructureEntityRendererJS(BlockEntityRendererProvider.Context context, MultiBlockStructure structure, Item item) {
        this.structure = structure;
        this.item = item;
    }

    public void render(BlockEntity entity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        boolean shouldRender = false;
        if (this.item == null || this.item.getDefaultInstance().is(Items.AIR) || this.item.getDefaultInstance().isEmpty()) {
            shouldRender = true;
        } else {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (player.getMainHandItem().is(this.item) || player.getOffhandItem().is(this.item))) {
                shouldRender = true;
            }
        }
        if (!shouldRender) {
            return;
        }
        BlockState blockState = entity.getBlockState();
        boolean hasDirection = blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING);
        boolean hasSpecialDirection = blockState.hasProperty((Property)RotatableBlock.FACING_HORIZONTAL);
        Direction direction = null;
        if (hasDirection) {
            direction = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        } else if (hasSpecialDirection) {
            direction = (Direction)blockState.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        }
        if (direction != null) {
            Level level = entity.getLevel();
            if (level == null) {
                return;
            }
            BlockPos machinePos = entity.getBlockPos();
            ++this.time;
            Pair<List<Pair<BlockPos, Block>>, List<Pair<BlockPos, Pair<List<Block>, TagKey<Block>>>>> poses = this.structure.getRenderStructure(direction, machinePos);
            RendererProvider provider = new RendererProvider(poseStack, multiBufferSource, machinePos);
            int minY = this.structure.getShouldRenderMinY(level, direction, machinePos);
            ((List)poses.getLeft()).forEach(pair -> {
                BlockPos pos = (BlockPos)pair.getLeft();
                BlockState state = ((Block)pair.getRight()).defaultBlockState();
                this.render(pos, state, provider, minY, !level.getBlockState(pos).is((Block)pair.getRight()));
            });
            ((List)poses.getRight()).forEach(pair -> {
                int index;
                BlockPos pos = (BlockPos)pair.getLeft();
                List blocks = (List)((Pair)pair.getRight()).getLeft();
                for (index = (int)Math.floor((double)this.time / 200.0); index >= blocks.size(); index -= blocks.size()) {
                }
                if (index < 0) {
                    index = 0;
                }
                BlockState state = ((Block)blocks.get(index)).defaultBlockState();
                this.render(pos, state, provider, minY, !level.getBlockState(pos).is((TagKey)((Pair)pair.getRight()).getRight()));
            });
        }
    }

    private void render(BlockPos pos, BlockState state, RendererProvider provider, int minY, boolean shouldRender) {
        if (shouldRender) {
            if (pos.getY() != minY) {
                boolean bl = false;
            } else {
                provider.renderSingleBatchedGhostBlock(pos, state);
            }
        }
    }
}

