/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.fluid;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidType;
import net.yxiao233.ifeu.api.fluid.AbstractAnimateFluidInstance;

public abstract class AbstractAnimateFluid
extends FlowingFluid {
    private final AbstractAnimateFluidInstance abstractAnimateFluidInstance;

    public AbstractAnimateFluid(AbstractAnimateFluidInstance abstractAnimateFluidInstance) {
        this.abstractAnimateFluidInstance = abstractAnimateFluidInstance;
    }

    public abstract void animateTick(Level var1, BlockPos var2, FluidState var3, RandomSource var4);

    @Nonnull
    public Fluid getFlowing() {
        return (Fluid)this.abstractAnimateFluidInstance.getFlowingFluid().get();
    }

    @Nonnull
    public Fluid getSource() {
        return (Fluid)this.abstractAnimateFluidInstance.getSourceFluid().get();
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return false;
    }

    protected boolean canConvertToSource(Level p_256009_) {
        return false;
    }

    @ParametersAreNonnullByDefault
    protected void beforeDestroyingBlock(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity != null) {
            Block.dropResources((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)blockEntity);
        }
    }

    protected int getSlopeFindDistance(@Nonnull LevelReader world) {
        return 4;
    }

    protected int getDropOff(@Nonnull LevelReader world) {
        return 1;
    }

    @Nonnull
    public Item getBucket() {
        return (Item)this.abstractAnimateFluidInstance.getBucketFluid().get();
    }

    @ParametersAreNonnullByDefault
    protected boolean canBeReplacedWith(FluidState p_215665_1_, BlockGetter p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !p_215665_4_.is(FluidTags.WATER);
    }

    public int getTickDelay(@Nonnull LevelReader p_205569_1_) {
        return 5;
    }

    protected float getExplosionResistance() {
        return 1.0f;
    }

    @Nonnull
    protected BlockState createLegacyBlock(@Nonnull FluidState state) {
        return (BlockState)((Block)this.abstractAnimateFluidInstance.getBlockFluid().get()).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(AbstractAnimateFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSource(@Nonnull FluidState state) {
        return false;
    }

    public int getAmount(@Nonnull FluidState p_207192_1_) {
        return 0;
    }

    public boolean isSame(Fluid fluidIn) {
        return fluidIn == this.abstractAnimateFluidInstance.getFlowingFluid().get() || fluidIn == this.abstractAnimateFluidInstance.getSourceFluid().get();
    }

    public FluidType getFluidType() {
        return (FluidType)this.abstractAnimateFluidInstance.getFluidType().get();
    }

    public static abstract class Flowing<T extends AbstractAnimateFluidInstance>
    extends AbstractAnimateFluid {
        public Flowing(T instance) {
            super((AbstractAnimateFluidInstance)instance);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        @Override
        public int getAmount(@Nonnull FluidState p_207192_1_) {
            return (Integer)p_207192_1_.getValue((Property)LEVEL);
        }

        @Override
        public boolean isSource(@Nonnull FluidState state) {
            return false;
        }

        @Override
        public abstract void animateTick(Level var1, BlockPos var2, FluidState var3, RandomSource var4);
    }

    public static abstract class Source<T extends AbstractAnimateFluidInstance>
    extends AbstractAnimateFluid {
        public Source(T instance) {
            super((AbstractAnimateFluidInstance)instance);
        }

        @Override
        public int getAmount(@Nonnull FluidState p_207192_1_) {
            return 8;
        }

        @Override
        public boolean isSource(@Nonnull FluidState state) {
            return true;
        }

        @Override
        public abstract void animateTick(Level var1, BlockPos var2, FluidState var3, RandomSource var4);
    }
}

