/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.jei;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.yxiao233.ifeu.common.gui.AllGuiTextures;
import net.yxiao233.ifeu.common.utils.TooltipCallBackHelper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJEICategory<T extends Recipe<?>>
implements IRecipeCategory<T> {
    public final RecipeType<T> type;
    public Component title;
    public final IDrawable background;
    public final IDrawable icon;

    public abstract net.minecraft.world.item.crafting.RecipeType<T> getTypeInstance();

    public AbstractJEICategory(IGuiHelper helper, RecipeType<T> type, Component title, Item icon, int width, int height) {
        ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)"textures/gui/empty.png");
        this.type = type;
        this.title = title;
        this.background = helper.createDrawable(TEXTURE, 0, 0, width, height);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)icon));
    }

    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    public Component getTitle() {
        return this.title;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public abstract void setRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);

    public abstract void draw(T var1, IRecipeSlotsView var2, GuiGraphics var3, double var4, double var6);

    public void addTooltips(GuiGraphics guiGraphics, int width, int height, Component[] components, int x, int y, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(width + x) && mouseY <= (double)(height + y)) {
            for (Component component : components) {
                list.add(component.getVisualOrderText());
            }
            guiGraphics.renderTooltip(font, list, (int)mouseX, (int)mouseY);
        }
    }

    public void addEnergyBarTooltip(GuiGraphics guiGraphics, Class<?> clazz, int width, int height, int x, int y, double mouseX, double mouseY) {
        int powerPerTick = 0;
        int maxProgress = 0;
        try {
            for (int i = 0; i < clazz.getFields().length; ++i) {
                Field field = clazz.getFields()[i];
                if (field.getName().equals("powerPerTick")) {
                    powerPerTick = field.getInt(field.getName());
                    continue;
                }
                if (!field.getName().equals("maxProgress")) continue;
                maxProgress = field.getInt(field.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.addTooltips(guiGraphics, width, height, new Component[]{Component.translatable((String)"jei.ifeu.power").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(powerPerTick)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" FE/tick").withStyle(ChatFormatting.DARK_AQUA)), Component.translatable((String)"jei.ifeu.progress").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(maxProgress)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" tick").withStyle(ChatFormatting.DARK_AQUA)), Component.translatable((String)"jei.ifeu.total").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(maxProgress * powerPerTick)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" FE").withStyle(ChatFormatting.DARK_AQUA))}, x, y, mouseX, mouseY);
    }

    public void addEnergyBarTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY, int stored, int capacity) {
        Rectangle rec = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.ENERGY_BACKGROUND).getArea();
        if (new Rectangle(0, 12, rec.width, rec.height).contains(mouseX, mouseY)) {
            Component[] components = new Component[2];
            String s = String.valueOf(ChatFormatting.GOLD);
            components[0] = Component.literal((String)(s + Component.translatable((String)"tooltip.titanium.power").getString()));
            s = new DecimalFormat().format(stored);
            components[1] = Component.literal((String)(s + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(capacity) + String.valueOf(ChatFormatting.DARK_AQUA) + " FE"));
            tooltip.add(FormattedText.composite((FormattedText[])components));
        }
    }

    public void addTooltipOnTexture(GuiGraphics guiGraphics, int width, int height, Component component, int x, int y, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(width + x) && mouseY <= (double)(height + y)) {
            guiGraphics.renderTooltip(font, component, (int)mouseX, (int)mouseY);
        }
    }

    public void drawTextureWithTooltip(GuiGraphics guiGraphics, AllGuiTextures allGuiTextures, Component component, int x, int y, double mouseX, double mouseY) {
        allGuiTextures.render(guiGraphics, x, y);
        this.addTooltipOnTexture(guiGraphics, allGuiTextures.width, allGuiTextures.height, component, x, y, mouseX, mouseY);
    }

    public IRecipeSlotRichTooltipCallback addText(String translatableKey, ChatFormatting style) {
        return (view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)translatableKey).withStyle(style));
    }

    public IRecipeSlotRichTooltipCallback addText(TooltipCallBackHelper ... tooltips) {
        return (view, tooltip) -> {
            for (int i = 0; i < tooltips.length; ++i) {
                tooltip.add((FormattedText)tooltips[i].getComponent());
            }
        };
    }
}

