/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.recipe.builder;

import com.buuz135.industrial.recipe.LaserDrillRarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.yxiao233.ifeu.common.registry.ModContents;

public abstract class IFEURecipeBuilder {
    private final ArrayList<String> structure = new ArrayList();
    private final HashMap<Character, ItemStack> defineMap = new HashMap();
    private final HashMap<Character, TagKey<Item>> defineTagMap = new HashMap();
    private List<Ingredient> inputs;
    private ItemStack input;
    private FluidStack inputFluid;
    private FluidStack[] inputFluids;
    private BlockState result;
    private ResourceLocation entity;
    private float breakChance;
    private Ingredient inputBlock;
    private Ingredient catalyst;
    private List<LaserDrillRarity> rarity;
    private FluidStack outputFluid;
    private String id;
    private String nameSpace;
    private boolean isDefaultRecipe;
    private int time;
    private final ItemStack output;

    public IFEURecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public IFEURecipeBuilder(ItemStack output, String id) {
        this.output = output;
        this.id = id;
    }

    public IFEURecipeBuilder id(String id) {
        this.id = id;
        return this;
    }

    public IFEURecipeBuilder inputFluid(FluidStack fluid) {
        this.inputFluid = fluid;
        return this;
    }

    public IFEURecipeBuilder inputFluids(FluidStack ... inputFluids) {
        this.inputFluids = inputFluids;
        return this;
    }

    public IFEURecipeBuilder outputFluid(FluidStack fluid) {
        this.outputFluid = fluid;
        return this;
    }

    public IFEURecipeBuilder inputs(Ingredient ... inputs) {
        this.inputs = List.of(inputs);
        return this;
    }

    public IFEURecipeBuilder catalyst(Ingredient catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public IFEURecipeBuilder isDefault(boolean isDefault) {
        this.isDefaultRecipe = isDefault;
        return this;
    }

    public IFEURecipeBuilder breakChance(float breakChance) {
        this.breakChance = breakChance;
        return this;
    }

    public IFEURecipeBuilder resultBlockState(BlockState result) {
        this.result = result;
        return this;
    }

    public IFEURecipeBuilder entity(ResourceLocation entityLocation) {
        this.entity = entityLocation;
        return this;
    }

    public IFEURecipeBuilder rarity(LaserDrillRarity ... rarity) {
        this.rarity = List.of(rarity);
        return this;
    }

    public IFEURecipeBuilder input(ItemStack stack) {
        this.input = stack;
        return this;
    }

    public IFEURecipeBuilder inputBlock(Ingredient input) {
        this.inputBlock = input;
        return this;
    }

    public IFEURecipeBuilder processingTime(int time) {
        this.time = time;
        return this;
    }

    public IFEURecipeBuilder pattern(String s) {
        this.structure.add(s);
        return this;
    }

    public IFEURecipeBuilder define(char symbol, ItemStack itemStack) {
        this.defineMap.put(Character.valueOf(symbol), itemStack);
        return this;
    }

    public IFEURecipeBuilder define(char symbol, TagKey<Item> itemTag) {
        this.defineTagMap.put(Character.valueOf(symbol), itemTag);
        return this;
    }

    public IFEURecipeBuilder define(char symbol, DeferredHolder<Item, Item> item) {
        this.define(symbol, ((Item)item.get()).getDefaultInstance());
        return this;
    }

    public abstract void save(RecipeOutput var1);

    protected ArrayList<String> getStructure() {
        if (this.structure.isEmpty()) {
            Object[] s = new String[9];
            Arrays.fill(s, " ");
            return new ArrayList<Object>(Arrays.asList(s));
        }
        return this.structure;
    }

    protected FluidStack getInputFluid() {
        return this.inputFluid;
    }

    protected FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    protected int getTime() {
        return Math.max(this.time, 0);
    }

    protected HashMap<Character, ItemStack> getDefineMap() {
        if (this.defineMap.isEmpty()) {
            this.defineMap.put(Character.valueOf(' '), ((Item)ModContents.AIR.get()).getDefaultInstance());
            return this.defineMap;
        }
        return this.defineMap;
    }

    protected HashMap<Character, TagKey<Item>> getDefineTagMap() {
        return this.defineTagMap;
    }

    protected String getId() {
        if (this.id == null || this.id.isEmpty()) {
            return this.output.getDescriptionId().substring(this.output.getDescriptionId().lastIndexOf(".") + 1);
        }
        return this.id;
    }

    protected String getNameSpace() {
        if (this.nameSpace == null || this.nameSpace.isEmpty()) {
            return "ifeu";
        }
        return this.nameSpace;
    }

    protected List<Ingredient> getInputs() {
        return this.inputs;
    }

    protected ItemStack getInput() {
        return this.input;
    }

    protected ResourceLocation getEntity() {
        return this.entity;
    }

    protected Ingredient getCatalyst() {
        return this.catalyst;
    }

    protected List<LaserDrillRarity> getRarity() {
        return this.rarity;
    }

    protected ResourceLocation getLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getNameSpace(), (String)this.getId());
    }

    protected Ingredient getInputBlock() {
        return this.inputBlock;
    }

    protected BlockState getResult() {
        return this.result;
    }

    protected float getBreakChance() {
        return this.breakChance;
    }

    protected boolean isDefault() {
        return this.isDefaultRecipe;
    }

    protected FluidStack[] getInputFluids() {
        return this.inputFluids;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

