/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.yxiao233.ifeu.common.config.machine.ArcaneDragonForgingConfig;
import net.yxiao233.ifeu.common.recipe.ArcaneDragonEggForgingRecipe;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModRecipes;
import org.jetbrains.annotations.NotNull;

public class ArcaneDragonEggForgingEntity
extends IndustrialProcessingTile<ArcaneDragonEggForgingEntity> {
    private int maxProgress;
    private int powerPerTick;
    @Save
    private SidedInventoryComponent<ArcaneDragonEggForgingEntity> input;
    @Save
    private SidedFluidTankComponent<ArcaneDragonEggForgingEntity> inputFluid1;
    @Save
    private SidedFluidTankComponent<ArcaneDragonEggForgingEntity> inputFluid2;
    @Save
    private SidedInventoryComponent<ArcaneDragonEggForgingEntity> output;
    @Save
    private SidedFluidTankComponent<ArcaneDragonEggForgingEntity> outputFluid;
    private ArcaneDragonEggForgingRecipe currentRecipe;

    public ArcaneDragonEggForgingEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.ARCANE_DRAGON_EGG_FORGING, 102, 41, blockPos, blockState);
        int slotSpacing = 22;
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 54 + slotSpacing, 18 + slotSpacing, 1, 0).setColor(DyeColor.LIGHT_BLUE).setRange(1, 1).setOutputFilter((itemStack, integer) -> false).setInputFilter((itemStack, integer) -> !this.canIncrease()).setOnSlotChanged((itemStack, integer) -> this.checkForRecipe()).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.input);
        this.inputFluid1 = (SidedFluidTankComponent)new SidedFluidTankComponent("input_fluid1", ArcaneDragonForgingConfig.maxInputTankSize, 32, 19, 1).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.NORMAL).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.checkForRecipe());
        this.addTank((FluidTankComponent)this.inputFluid1);
        this.inputFluid2 = (SidedFluidTankComponent)new SidedFluidTankComponent("input_fluid2", ArcaneDragonForgingConfig.maxInputTankSize, 52, 19, 2).setColor(DyeColor.ORANGE).setTankType(FluidTankComponent.Type.NORMAL).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.checkForRecipe());
        this.addTank((FluidTankComponent)this.inputFluid2);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 129, 22, 3, 3).setColor(DyeColor.MAGENTA).setRange(1, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.outputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("output_fluid", ArcaneDragonForgingConfig.maxOutputTankSize, 149, 20, 4).setColor(DyeColor.RED).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank((FluidTankComponent)this.outputFluid);
        this.maxProgress = 100;
        this.powerPerTick = ArcaneDragonForgingConfig.powerPerTick;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.currentRecipe != null && this.currentRecipe.matches((IItemHandler)this.input, (FluidTankComponent)this.inputFluid1, (FluidTankComponent)this.inputFluid2)) {
                return;
            }
            this.currentRecipe = RecipeUtil.getRecipes((Level)this.level, (RecipeType)((RecipeType)ModRecipes.ARCANE_DRAGON_EGG_FORGING_TYPE.get())).stream().filter(recipe -> recipe.matches((IItemHandler)this.input, (FluidTankComponent)this.inputFluid1, (FluidTankComponent)this.inputFluid2)).findFirst().orElse(null);
        }
    }

    public void setChanged() {
        super.setChanged();
        this.checkForRecipe();
    }

    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        this.checkForRecipe();
    }

    public boolean canIncrease() {
        if (this.currentRecipe != null) {
            boolean hasCurrentItem = this.currentRecipe.output.get() == null || ItemHandlerHelper.insertItem(this.output, (ItemStack)this.currentRecipe.output.get().copy(), (boolean)true).isEmpty();
            boolean hasEnoughCount = this.input.getStackInSlot(0).getCount() >= this.currentRecipe.input.getCount();
            boolean canFillFluid = this.currentRecipe.outputFluid == null || this.outputFluid.fillForced(this.currentRecipe.outputFluid.get().copy(), IFluidHandler.FluidAction.SIMULATE) == this.currentRecipe.outputFluid.get().getAmount();
            return this.currentRecipe != null && hasCurrentItem && hasEnoughCount && canFillFluid;
        }
        return false;
    }

    public Runnable onFinish() {
        return () -> {
            if (this.currentRecipe != null) {
                ArcaneDragonEggForgingRecipe arcaneDragonEggForgingRecipe = this.currentRecipe;
                this.inputFluid1.drainForced(arcaneDragonEggForgingRecipe.inputFluid1, IFluidHandler.FluidAction.EXECUTE);
                this.inputFluid2.drainForced(arcaneDragonEggForgingRecipe.inputFluid2, IFluidHandler.FluidAction.EXECUTE);
                this.input.getStackInSlot(0).shrink(arcaneDragonEggForgingRecipe.input.getCount());
                if (arcaneDragonEggForgingRecipe.outputFluid.get() != null && !arcaneDragonEggForgingRecipe.outputFluid.isEmpty()) {
                    this.outputFluid.fillForced(arcaneDragonEggForgingRecipe.outputFluid.get().copy(), IFluidHandler.FluidAction.EXECUTE);
                }
                if (arcaneDragonEggForgingRecipe.output.get() != null) {
                    ItemStack outputStack = arcaneDragonEggForgingRecipe.output.get().copy();
                    outputStack.getItem().onCraftedBy(outputStack, this.level, (Player)null);
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
                }
                this.checkForRecipe();
            }
        };
    }

    @NotNull
    protected EnergyStorageComponent<ArcaneDragonEggForgingEntity> createEnergyStorage() {
        return new EnergyStorageComponent(ArcaneDragonForgingConfig.maxStoredPower, 10, 20);
    }

    protected int getTickPower() {
        return ArcaneDragonForgingConfig.powerPerTick;
    }

    public int getMaxProgress() {
        return this.currentRecipe != null ? this.currentRecipe.processingTime : this.maxProgress;
    }

    @NotNull
    public ArcaneDragonEggForgingEntity getSelf() {
        return this;
    }
}

