/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.yxiao233.ifeu.common.config.machine.InfuserConfig;
import net.yxiao233.ifeu.common.recipe.InfuserRecipe;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModRecipes;
import org.jetbrains.annotations.NotNull;

public class InfuserEntity
extends IndustrialProcessingTile<InfuserEntity> {
    private int maxProgress;
    private int powerPerTick;
    @Save
    private SidedInventoryComponent<InfuserEntity> input;
    @Save
    private SidedFluidTankComponent<InfuserEntity> inputFluid;
    @Save
    private SidedInventoryComponent<InfuserEntity> output;
    private InfuserRecipe currentRecipe;

    public InfuserEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.INFUSER, 102, 41, blockPos, blockState);
        int slotSpacing = 22;
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 54 + slotSpacing, 18 + slotSpacing, 1, 0).setColor(DyeColor.LIGHT_BLUE).setRange(1, 1).setOutputFilter((itemStack, integer) -> false).setInputFilter((itemStack, integer) -> !this.canIncrease()).setOnSlotChanged((itemStack, integer) -> this.checkForRecipe()).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.input);
        this.inputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("input_fluid", InfuserConfig.maxInputTankSize, 52, 19, 1).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.NORMAL).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.checkForRecipe());
        this.addTank((FluidTankComponent)this.inputFluid);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 129, 22, 3, 2).setColor(DyeColor.ORANGE).setRange(1, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.maxProgress = 100;
        this.powerPerTick = InfuserConfig.powerPerTick;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            Item item;
            if (this.currentRecipe != null && this.currentRecipe.matches((IItemHandler)this.input, (FluidTankComponent)this.inputFluid)) {
                return;
            }
            this.currentRecipe = RecipeUtil.getRecipes((Level)this.level, (RecipeType)((RecipeType)ModRecipes.INFUSER_TYPE.get())).stream().filter(recipe -> recipe.matches((IItemHandler)this.input, (FluidTankComponent)this.inputFluid)).findFirst().orElse(null);
            if (this.currentRecipe == null && this.input.getStackInSlot(0).is(Items.BUCKET) && (item = this.inputFluid.getFluid().getFluid().getBucket()) instanceof BucketItem) {
                FluidStack fluidStack = new FluidStack(this.inputFluid.getFluid().getFluid(), 1000);
                this.currentRecipe = new InfuserRecipe(Items.BUCKET.getDefaultInstance(), fluidStack, 200, item.getDefaultInstance());
            }
        }
    }

    public void setChanged() {
        super.setChanged();
        this.checkForRecipe();
    }

    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        this.checkForRecipe();
    }

    public boolean canIncrease() {
        if (this.currentRecipe != null) {
            boolean hasCurrentItem = ItemHandlerHelper.insertItem(this.output, (ItemStack)this.currentRecipe.output.copy(), (boolean)true).isEmpty();
            boolean hasEnoughCount = this.input.getStackInSlot(0).getCount() >= this.currentRecipe.input.getCount();
            return hasCurrentItem && hasEnoughCount;
        }
        return false;
    }

    public Runnable onFinish() {
        return () -> {
            if (this.currentRecipe != null) {
                InfuserRecipe infuserRecipe = this.currentRecipe;
                this.input.getStackInSlot(0).shrink(infuserRecipe.input.getCount());
                this.inputFluid.drainForced(infuserRecipe.inputFluid, IFluidHandler.FluidAction.EXECUTE);
                ItemStack outputStack = infuserRecipe.output.copy();
                outputStack.getItem().onCraftedBy(outputStack, this.level, null);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
                this.checkForRecipe();
            }
        };
    }

    @NotNull
    protected EnergyStorageComponent<InfuserEntity> createEnergyStorage() {
        return new EnergyStorageComponent(InfuserConfig.maxStoredPower, 10, 20);
    }

    protected int getTickPower() {
        return this.powerPerTick;
    }

    public int getMaxProgress() {
        return this.currentRecipe != null ? this.currentRecipe.processingTime : this.maxProgress;
    }

    @NotNull
    public InfuserEntity getSelf() {
        return this;
    }
}

