/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.yxiao233.ifeu.api.block.entity.IFEUAreaWorkingTile;
import net.yxiao233.ifeu.api.components.ComponentGuiComponent;
import net.yxiao233.ifeu.api.components.CustomTooltipComponent;
import net.yxiao233.ifeu.api.components.TextGuiComponent;
import net.yxiao233.ifeu.api.networking.BooleanValueSyncS2C;
import net.yxiao233.ifeu.common.config.machine.PlatformBuilderConfig;
import net.yxiao233.ifeu.common.networking.packet.BooleanSyncS2CPacket;
import net.yxiao233.ifeu.common.networking.packet.PlatformBuilderEntityKeyDownSyncC2SPacket;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.utils.KeyDownUtil;
import net.yxiao233.ifeu.common.utils.PlatformBuilderUtil;
import org.jetbrains.annotations.NotNull;

public class PlatformBuilderEntity
extends IFEUAreaWorkingTile<PlatformBuilderEntity>
implements BooleanValueSyncS2C {
    @Save
    public boolean isNorth = false;
    @Save
    boolean isWest = false;
    @Save
    public InventoryComponent<PlatformBuilderEntity> land;
    @Save
    public InventoryComponent<PlatformBuilderEntity> frame = new SidedInventoryComponent("frame_input", 46, 22, 1, 0).setColor(DyeColor.YELLOW).setInputFilter((stack, integer) -> stack.getItem() instanceof BlockItem).setOutputFilter((stack, integer) -> false).setSlotLimit(256).setOnSlotChanged((stack, integer) -> this.resetIndex()).setComponentHarness((IComponentHarness)this);
    @Save
    private int landRange;
    @Save
    private int frameBounds;
    @Save
    private int landIndex;
    @Save
    private int frameIndex;
    @Save
    public boolean hasButtonTip = true;
    @Save
    public int mode = 0;
    private String uuid = "d28b7061-fb12-4064-90fb-7e02b95c72a5";
    public static boolean isShiftDown;
    private boolean finish = false;
    private static final int maxLandRange;
    private static final int maxFrameBounds;

    public PlatformBuilderEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.PLATFORM_BUILDER, 0, blockPos, blockState);
        this.addInventory(this.frame);
        this.land = new SidedInventoryComponent("land_input", 46, 57, 1, 1).setColor(DyeColor.GREEN).setInputFilter((stack, integer) -> stack.getItem() instanceof BlockItem).setOutputFilter((stack, integer) -> false).setSlotLimit(256).setOnSlotChanged((stack, integer) -> this.resetIndex()).setComponentHarness((IComponentHarness)this);
        this.addInventory(this.land);
        this.addButton(new ArrowButtonComponent(70, 20, 14, 14, FacingUtil.Sideness.LEFT).setId(2).setPredicate((playerEntity, compoundNBT) -> {
            this.isNorth = !this.isNorth;
            this.resetIndex();
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(115, 20, 14, 14, FacingUtil.Sideness.RIGHT).setId(3).setPredicate((playerEntity, compoundNBT) -> {
            this.isNorth = !this.isNorth;
            this.resetIndex();
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(70, 40, 14, 14, FacingUtil.Sideness.LEFT).setId(4).setPredicate((playerEntity, compoundNBT) -> {
            this.isWest = !this.isWest;
            this.resetIndex();
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(115, 40, 14, 14, FacingUtil.Sideness.RIGHT).setId(5).setPredicate((playerEntity, compoundNBT) -> {
            this.isWest = !this.isWest;
            this.resetIndex();
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(155, 21, 14, 14, FacingUtil.Sideness.TOP).setId(6).setPredicate((playerEntity, compoundNBT) -> {
            this.landRange = isShiftDown ? (this.landRange += 10) : ++this.landRange;
            if (this.landRange > maxLandRange) {
                this.landRange = 0;
            }
            this.resetIndex();
            this.finish = false;
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(155, 58, 14, 14, FacingUtil.Sideness.BOTTOM).setId(7).setPredicate((playerEntity, compoundNBT) -> {
            this.landRange = isShiftDown ? (this.landRange -= 10) : --this.landRange;
            if (this.landRange < 0) {
                this.landRange = maxLandRange;
            }
            this.resetIndex();
            this.finish = false;
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(135, 21, 14, 14, FacingUtil.Sideness.TOP).setId(8).setPredicate((playerEntity, compoundNBT) -> {
            this.frameBounds = isShiftDown ? (this.frameBounds += 10) : ++this.frameBounds;
            if (this.frameBounds > maxFrameBounds) {
                this.frameBounds = 0;
            }
            this.resetIndex();
            this.finish = false;
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(135, 58, 14, 14, FacingUtil.Sideness.BOTTOM).setId(9).setPredicate((playerEntity, compoundNBT) -> {
            this.frameBounds = isShiftDown ? (this.frameBounds -= 10) : --this.frameBounds;
            if (this.frameBounds < 0) {
                this.frameBounds = maxFrameBounds;
            }
            this.resetIndex();
            this.finish = false;
            this.markForUpdate();
        }));
        this.addButton(new ButtonComponent(118, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            @NotNull
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    StateButtonInfo[] buttonInfo = new StateButtonInfo[2];
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_ENABLED;
                    String[] tip = new String[2];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = String.valueOf(chatFormatting) + LangUtil.getString((String)"tooltip.ifeu.time_controller.has_tip", (Object[])new Object[0]);
                    tip[1] = "tooltip.ifeu.time_controller.has_tip_1";
                    buttonInfo[0] = new StateButtonInfo(0, asset, tip);
                    asset = AssetTypes.BUTTON_SIDENESS_DISABLED;
                    tip = new String[]{String.valueOf(chatFormatting) + LangUtil.getString((String)"tooltip.ifeu.time_controller.without_tip", (Object[])new Object[0]), "tooltip.ifeu.time_controller.without_tip_1"};
                    buttonInfo[1] = new StateButtonInfo(1, asset, tip);
                    return new StateButtonAddon(this, buttonInfo){

                        public int getState() {
                            return PlatformBuilderEntity.this.hasButtonTip ? 0 : 1;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.hasButtonTip = !this.hasButtonTip;
            this.markForUpdate();
        }).setId(10));
        this.addButton(new ButtonComponent(100, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            @NotNull
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    StateButtonInfo[] buttonInfo = new StateButtonInfo[2];
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_DISABLED;
                    String[] tip = new String[2];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = String.valueOf(chatFormatting) + LangUtil.getString((String)"tooltip.ifeu.platform_builder.destroy", (Object[])new Object[0]);
                    tip[1] = "tooltip.ifeu.platform_builder.destroy_1";
                    buttonInfo[0] = new StateButtonInfo(0, asset, tip);
                    asset = AssetTypes.BUTTON_SIDENESS_ENABLED;
                    tip = new String[]{String.valueOf(chatFormatting) + LangUtil.getString((String)"tooltip.ifeu.platform_builder.skip", (Object[])new Object[0]), "tooltip.ifeu.platform_builder.skip_1"};
                    buttonInfo[1] = new StateButtonInfo(1, asset, tip);
                    return new StateButtonAddon(this, buttonInfo){

                        public int getState() {
                            return PlatformBuilderEntity.this.mode;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.mode = this.mode >= 1 ? 0 : 1;
            this.markForUpdate();
        }).setId(11));
        this.addButton(new ButtonComponent(this, 82, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            @NotNull
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_PUSH;
                    String[] tip = new String[1];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = String.valueOf(chatFormatting) + LangUtil.getString((String)"tooltip.ifeu.platform_builder.reset", (Object[])new Object[0]);
                    StateButtonInfo info = new StateButtonInfo(0, asset, tip);
                    return new StateButtonAddon(this, this, new StateButtonInfo[]{info}){

                        public int getState() {
                            return 0;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.resetIndex();
            this.markForUpdate();
        }).setId(12));
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, PlatformBuilderEntity blockEntity) {
        if (this.landRange < 0) {
            this.landRange = maxLandRange;
        } else if (this.landRange > maxLandRange) {
            this.landRange = 0;
        }
        if (this.frameBounds < 0) {
            this.frameBounds = maxFrameBounds;
        } else if (this.frameBounds > maxFrameBounds) {
            this.frameBounds = 0;
        }
        if (level.isClientSide()) {
            isShiftDown = KeyDownUtil.isShiftKeyDown();
            PacketDistributor.sendToServer((CustomPacketPayload)new PlatformBuilderEntityKeyDownSyncC2SPacket(isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, PlatformBuilderEntity blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (!level.isClientSide()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BooleanSyncS2CPacket(pos, List.of(Boolean.valueOf(this.finish))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new ComponentGuiComponent(99, 22){

            @Override
            public Component getText() {
                return PlatformBuilderEntity.this.isNorth ? Component.translatable((String)"direction.ifeu.north") : Component.translatable((String)"direction.ifeu.south");
            }
        });
        this.addGuiAddonFactory(() -> new ComponentGuiComponent(99, 43){

            @Override
            public Component getText() {
                return PlatformBuilderEntity.this.isWest ? Component.translatable((String)"direction.ifeu.west") : Component.translatable((String)"direction.ifeu.east");
            }
        });
        this.addGuiAddonFactory(() -> new TextGuiComponent(139, 43){

            @Override
            public String getText() {
                return String.valueOf(PlatformBuilderEntity.this.frameBounds);
            }
        });
        this.addGuiAddonFactory(() -> new TextGuiComponent(159, 43){

            @Override
            public String getText() {
                return String.valueOf(PlatformBuilderEntity.this.landRange);
            }
        });
        this.addGuiAddonFactory(() -> new CustomTooltipComponent(135, 19){

            @Override
            public int[] width$height() {
                return new int[]{14, 14};
            }

            @Override
            public Component[] getComponents() {
                return 8.platformBuilder("add", "frame_bounds");
            }

            @Override
            public boolean hasTooltip() {
                return PlatformBuilderEntity.this.hasButtonTip;
            }
        });
        this.addGuiAddonFactory(() -> new CustomTooltipComponent(135, 58){

            @Override
            public int[] width$height() {
                return new int[]{14, 14};
            }

            @Override
            public Component[] getComponents() {
                return 9.platformBuilder("reduce", "frame_bounds");
            }

            @Override
            public boolean hasTooltip() {
                return PlatformBuilderEntity.this.hasButtonTip;
            }
        });
        this.addGuiAddonFactory(() -> new CustomTooltipComponent(155, 19){

            @Override
            public int[] width$height() {
                return new int[]{14, 14};
            }

            @Override
            public Component[] getComponents() {
                return 10.platformBuilder("add", "land_range");
            }

            @Override
            public boolean hasTooltip() {
                return PlatformBuilderEntity.this.hasButtonTip;
            }
        });
        this.addGuiAddonFactory(() -> new CustomTooltipComponent(155, 58){

            @Override
            public int[] width$height() {
                return new int[]{14, 14};
            }

            @Override
            public Component[] getComponents() {
                return 11.platformBuilder("reduce", "land_range");
            }

            @Override
            public boolean hasTooltip() {
                return PlatformBuilderEntity.this.hasButtonTip;
            }
        });
    }

    public int getMaxProgress() {
        return PlatformBuilderConfig.maxProgress;
    }

    public IndustrialWorkingTile.WorkAction work() {
        boolean frame;
        List<BlockPos> frames = PlatformBuilderUtil.getFrameBlockPosList(this);
        List<BlockPos> lands = PlatformBuilderUtil.getLandPosList(this);
        int needFrame = frames.size() - this.frameIndex;
        int needLand = lands.size() - this.landIndex;
        ItemStack landStack = this.land.getStackInSlot(0);
        ItemStack frameStack = this.frame.getStackInSlot(0);
        boolean land = landStack.getCount() > 0;
        boolean bl = frame = frameStack.getCount() > 0;
        if (land) {
            if (needLand > 0) {
                if (this.mode == 0) {
                    this.replace(lands.get(this.landIndex), this.getLandBlockState(), "land");
                } else {
                    this.skip(lands.get(this.landIndex), this.getLandBlockState(), "land");
                }
                return new IndustrialWorkingTile.WorkAction((IndustrialWorkingTile)this, 1.0f, PlatformBuilderConfig.powerPerOperation);
            }
            if (frame && needFrame > 0) {
                if (this.mode == 0) {
                    this.replace(frames.get(this.frameIndex), this.getFrameBlockState(), "frame");
                } else {
                    this.skip(frames.get(this.frameIndex), this.getFrameBlockState(), "frame");
                }
                return new IndustrialWorkingTile.WorkAction((IndustrialWorkingTile)this, 1.0f, PlatformBuilderConfig.powerPerOperation);
            }
        } else if (frame && needFrame > 0) {
            if (this.mode == 0) {
                this.replace(frames.get(this.frameIndex), this.getFrameBlockState(), "frame");
            } else {
                this.skip(frames.get(this.frameIndex), this.getFrameBlockState(), "frame");
            }
            return new IndustrialWorkingTile.WorkAction((IndustrialWorkingTile)this, 1.0f, PlatformBuilderConfig.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction((IndustrialWorkingTile)this, 1.0f, 0);
    }

    private void replace(BlockPos pos, BlockState state, String type) {
        FakePlayer fakePlayer = IndustrialForegoing.getFakePlayer((Level)this.level, (BlockPos)pos, (String)this.uuid);
        fakePlayer.setGameMode(GameType.SURVIVAL);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
        if (this.level.getBlockState(pos).isAir()) {
            this.level.setBlockAndUpdate(pos, state);
            this.shrink(type);
            this.increaseIndex(type);
        } else if (this.level.getBlockState(pos).is(state.getBlock())) {
            this.increaseIndex(type);
        } else if (this.level.getBlockState(pos).getDestroySpeed((BlockGetter)this.level, pos) >= 0.0f && this.level.getBlockState(pos).canHarvestBlock((BlockGetter)this.level, pos, (Player)fakePlayer)) {
            this.shrink(type);
            this.level.destroyBlock(pos, true);
            this.level.setBlockAndUpdate(pos, state);
            this.increaseIndex(type);
        }
    }

    private void skip(BlockPos pos, BlockState state, String type) {
        if (this.level.getBlockState(pos).isAir()) {
            this.shrink(type);
            this.level.setBlockAndUpdate(pos, state);
            this.increaseIndex(type);
        } else {
            this.increaseIndex(type);
        }
    }

    private void shrink(String type) {
        if (type.equals("frame")) {
            this.frame.getStackInSlot(0).shrink(1);
        } else {
            this.land.getStackInSlot(0).shrink(1);
        }
    }

    private void increaseIndex(String type) {
        if (type.equals("frame")) {
            ++this.frameIndex;
        } else {
            ++this.landIndex;
        }
    }

    private void resetIndex() {
        this.frameIndex = 0;
        this.landIndex = 0;
    }

    @NotNull
    public PlatformBuilderEntity getSelf() {
        return this;
    }

    protected EnergyStorageComponent<PlatformBuilderEntity> createEnergyStorage() {
        return new EnergyStorageComponent(PlatformBuilderConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getFrameBounds() {
        return this.frameBounds;
    }

    @Override
    public IFEUAreaWorkingTile.FrameDirection getFrameDirection() {
        return new IFEUAreaWorkingTile.FrameDirection(this.isNorth ? IFEUAreaWorkingTile.NorthSouth.NORTH : IFEUAreaWorkingTile.NorthSouth.SOUTH, this.isWest ? IFEUAreaWorkingTile.WestEast.WEST : IFEUAreaWorkingTile.WestEast.EAST);
    }

    @Override
    public int getLandRange() {
        return this.landRange;
    }

    @Override
    public int getYOffset() {
        return -1;
    }

    @Override
    public BlockState getFrameBlockState() {
        if (!this.frame.getStackInSlot(0).isEmpty()) {
            return Block.byItem((Item)this.frame.getStackInSlot(0).getItem()).defaultBlockState();
        }
        return Blocks.LIME_STAINED_GLASS.defaultBlockState();
    }

    @Override
    public BlockState getLandBlockState() {
        if (!this.land.getStackInSlot(0).isEmpty()) {
            return Block.byItem((Item)this.land.getStackInSlot(0).getItem()).defaultBlockState();
        }
        return Blocks.GLASS.defaultBlockState();
    }

    @Override
    public BlockPos getCenter() {
        return null;
    }

    @Override
    public Item getLandItem() {
        if (this.land.getStackInSlot(0).isEmpty()) {
            return Items.AIR;
        }
        return this.land.getStackInSlot(0).getItem();
    }

    @Override
    public Item getFrameItem() {
        if (this.frame.getStackInSlot(0).isEmpty()) {
            return Items.AIR;
        }
        return this.frame.getStackInSlot(0).getItem();
    }

    @Override
    public void setValue(List<Boolean> values) {
        this.finish = values.getFirst();
    }

    @Override
    public List<Boolean> getValues() {
        return List.of(Boolean.valueOf(this.finish));
    }

    public void saveSettings(Player player, CompoundTag tag) {
        if (tag.contains("is_north")) {
            this.isNorth = tag.getBoolean("is_north");
        }
        if (tag.contains("is_west")) {
            this.isWest = tag.getBoolean("is_west");
        }
        if (tag.contains("land_range")) {
            this.landRange = tag.getInt("land_range");
        }
        if (tag.contains("frame_bounds")) {
            this.frameBounds = tag.getInt("frame_bounds");
        }
        if (tag.contains("land_index")) {
            this.landIndex = tag.getInt("land_index");
        }
        if (tag.contains("frame_index")) {
            this.frameIndex = tag.getInt("frame_index");
        }
        if (tag.contains("mode")) {
            this.mode = tag.getInt("mode");
        }
        if (tag.contains("hideButtonTip")) {
            this.hasButtonTip = tag.getBoolean("hideButtonTip");
        }
        super.loadSettings(player, tag);
    }

    public void loadSettings(Player player, CompoundTag tag) {
        tag.putBoolean("is_north", this.isNorth);
        tag.putBoolean("is_west", this.isWest);
        tag.putInt("land_range", this.landRange);
        tag.putInt("frame_bounds", this.frameBounds);
        tag.putInt("land_index", this.landIndex);
        tag.putInt("frame_index", this.frameIndex);
        tag.putInt("mode", this.mode);
        tag.putBoolean("hideButtonTip", this.hasButtonTip);
        super.saveSettings(player, tag);
    }

    static {
        maxLandRange = PlatformBuilderConfig.maxLandRange;
        maxFrameBounds = PlatformBuilderConfig.maxFrameBounds;
    }
}

