/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.yxiao233.ifeu.common.block.entity.FluidTransferEntity;
import net.yxiao233.ifeu.common.item.ConnectToolItem;
import net.yxiao233.ifeu.common.registry.ModDataComponentTypes;
import net.yxiao233.ifeu.common.utils.RendererProvider;

public class FluidTransferRenderer
implements BlockEntityRenderer<FluidTransferEntity> {
    public FluidTransferRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FluidTransferEntity entity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay) {
        ItemStack stack;
        if (!entity.isFluidRender) {
            return;
        }
        RendererProvider provider = new RendererProvider(poseStack, multiBufferSource, entity.getBlockPos());
        provider.renderFullFluid((BlockEntity)entity, entity.fluidStored.getFluid(), combinedLight);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (stack = player.getMainHandItem()).getItem() instanceof ConnectToolItem) {
            BlockPos pos;
            Color color;
            int[] temp;
            CompoundTag tag = (CompoundTag)stack.get(ModDataComponentTypes.COMPOUND_TAG);
            if (tag != null && tag.contains("pos1")) {
                temp = tag.getIntArray("pos1");
                color = new Color(55, 255, 55);
                pos = new BlockPos(temp[0], temp[1], temp[2]);
                provider.renderBlockLineBox(pos, color);
                provider.renderCenterVerticalLine(pos, 5, color);
            }
            if (tag != null && tag.contains("pos2")) {
                temp = tag.getIntArray("pos2");
                color = new Color(0, 255, 255);
                pos = new BlockPos(temp[0], temp[1], temp[2]);
                provider.renderBlockLineBox(pos, color);
                provider.renderCenterVerticalLine(pos, 5, color);
            }
        }
    }
}

