/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.item;

import com.buuz135.industrial.item.addon.EfficiencyAddonItem;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.item.addon.SpeedAddonItem;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block.tile.MachineTile;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import net.yxiao233.ifeu.api.item.IFEUAddonItem;
import net.yxiao233.ifeu.api.item.ModThreadAddonItem;
import net.yxiao233.ifeu.common.networking.packet.ConfigurationToolItemKeyDownSyncC2SPacket;
import net.yxiao233.ifeu.common.registry.ModDataComponentTypes;
import net.yxiao233.ifeu.common.utils.InventoryComponentHelper;
import net.yxiao233.ifeu.common.utils.KeyDownUtil;
import net.yxiao233.ifeu.common.utils.TooltipHelper;

public class ConfigurationToolItem
extends Item {
    public static boolean isCtrlDown;

    public ConfigurationToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide()) {
            isCtrlDown = KeyDownUtil.isCtrlKeyDown();
            PacketDistributor.sendToServer((CustomPacketPayload)new ConfigurationToolItemKeyDownSyncC2SPacket(isCtrlDown), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!level.isClientSide()) {
            Player player = context.getPlayer();
            if (player == null) {
                return InteractionResult.PASS;
            }
            if (context.getHand() != InteractionHand.MAIN_HAND) {
                return InteractionResult.PASS;
            }
            if (player.isShiftKeyDown() && !isCtrlDown) {
                return this.addConfigToTag(context);
            }
            if (player.isShiftKeyDown() && isCtrlDown) {
                return this.applyConfig(context);
            }
        }
        return super.useOn(context);
    }

    private InteractionResult addConfigToTag(UseOnContext context) {
        CompoundTag facingTag;
        Iterator iterator;
        Level level = context.getLevel();
        BlockPos clickedBlockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(clickedBlockPos);
        Block block = blockState.getBlock();
        ItemStack stack = context.getItemInHand();
        CompoundTag emptyTag = new CompoundTag();
        CompoundTag tag = new CompoundTag();
        AtomicReference<NonNullList> invFacings = new AtomicReference<NonNullList>(NonNullList.create());
        AtomicReference<NonNullList> invConfigName = new AtomicReference<NonNullList>(NonNullList.create());
        AtomicBoolean hasInvConfig = new AtomicBoolean(false);
        CompoundTag invFacingsTag = new CompoundTag();
        AtomicReference<NonNullList> fluidFacings = new AtomicReference<NonNullList>(NonNullList.create());
        AtomicReference<NonNullList> fluidConfigName = new AtomicReference<NonNullList>(NonNullList.create());
        AtomicBoolean hasFluidConfig = new AtomicBoolean(false);
        CompoundTag fluidFacingsTag = new CompoundTag();
        CompoundTag augmentsTag = new CompoundTag();
        AtomicBoolean hasAugments = new AtomicBoolean(false);
        if (blockState.hasBlockEntity()) {
            BlockEntity blockEntity = level.getBlockEntity(clickedBlockPos);
            if (blockEntity instanceof ActiveTile) {
                ActiveTile activeTile = (ActiveTile)blockEntity;
                if (activeTile.getMultiInventoryComponent() != null) {
                    activeTile.getMultiInventoryComponent().getInventoryHandlers().forEach(component -> {
                        SidedInventoryComponent side;
                        if (component instanceof SidedInventoryComponent && !(side = (SidedInventoryComponent)component).getName().equals("augments")) {
                            hasInvConfig.set(true);
                            ((NonNullList)invFacings.get()).add((Object)side.getFacingModes());
                            ((NonNullList)invConfigName.get()).add((Object)side.getName());
                        }
                    });
                }
                if (activeTile.getMultiTankComponent() != null) {
                    activeTile.getMultiTankComponent().getTanks().forEach(component -> {
                        if (component instanceof SidedFluidTankComponent) {
                            SidedFluidTankComponent side = (SidedFluidTankComponent)component;
                            hasFluidConfig.set(true);
                            ((NonNullList)fluidFacings.get()).add((Object)side.getFacingModes());
                            ((NonNullList)fluidConfigName.get()).add((Object)side.getName());
                        }
                    });
                }
            }
            if (blockEntity instanceof MachineTile) {
                MachineTile machineTile = (MachineTile)blockEntity;
                SidedInventoryComponent invComponent = machineTile.getAugmentInventory();
                int m = 0;
                for (int i = 0; i < invComponent.getSlots(); ++i) {
                    CompoundTag tagg;
                    ItemStack aug = invComponent.getStackInSlot(i);
                    Item item = aug.getItem();
                    if (item instanceof IFEUAddonItem) {
                        IFEUAddonItem addonItem = (IFEUAddonItem)item;
                        if (aug.isEmpty()) continue;
                        hasAugments.set(true);
                        tagg = new CompoundTag();
                        tagg.putFloat("float", (float)addonItem.getTier());
                        tagg.putString("string", addonItem.getType().getId());
                        tagg.putString("item_id", String.valueOf(BuiltInRegistries.ITEM.getKey((Object)aug.getItem())));
                        augmentsTag.put("augment" + m, (Tag)tagg);
                        ++m;
                        continue;
                    }
                    if (aug.isEmpty() || aug.get((Supplier)AugmentWrapper.ATTACHMENT) == null) continue;
                    tagg = new CompoundTag();
                    hasAugments.set(true);
                    ((Map)aug.get((Supplier)AugmentWrapper.ATTACHMENT)).forEach((s, f) -> {
                        tagg.putFloat("float", f.floatValue());
                        tagg.putString("string", s);
                    });
                    tagg.putString("item_id", String.valueOf(BuiltInRegistries.ITEM.getKey((Object)aug.getItem())));
                    augmentsTag.put("augment" + m, (Tag)tagg);
                    ++m;
                }
            }
        } else {
            return InteractionResult.PASS;
        }
        if (hasInvConfig.get()) {
            if (invFacings.get().isEmpty()) {
                stack.set(ModDataComponentTypes.COMPOUND_TAG, (Object)emptyTag);
                return InteractionResult.FAIL;
            }
            for (int i = 0; i < invFacings.get().size(); ++i) {
                iterator = ((HashMap)invFacings.get().get(i)).keySet().iterator();
                facingTag = new CompoundTag();
                while (iterator.hasNext()) {
                    FacingUtil.Sideness facing = (FacingUtil.Sideness)iterator.next();
                    facingTag.putString(facing.name(), ((IFacingComponent.FaceMode)((HashMap)invFacings.get().get(i)).get(facing)).name());
                }
                invFacingsTag.put((String)invConfigName.get().get(i), (Tag)facingTag);
            }
            tag.put("invFacingModes", (Tag)invFacingsTag);
        }
        if (hasFluidConfig.get()) {
            if (fluidFacings.get().isEmpty()) {
                stack.set(ModDataComponentTypes.COMPOUND_TAG, (Object)emptyTag);
                return InteractionResult.FAIL;
            }
            for (int i = 0; i < fluidFacings.get().size(); ++i) {
                iterator = ((Map)fluidFacings.get().get(i)).keySet().iterator();
                facingTag = new CompoundTag();
                while (iterator.hasNext()) {
                    FacingUtil.Sideness facing = (FacingUtil.Sideness)iterator.next();
                    facingTag.putString(facing.name(), ((IFacingComponent.FaceMode)((Map)fluidFacings.get().get(i)).get(facing)).name());
                }
                fluidFacingsTag.put((String)fluidConfigName.get().get(i), (Tag)facingTag);
            }
            tag.put("fluidFacingModes", (Tag)fluidFacingsTag);
        }
        if (hasAugments.get()) {
            if (augmentsTag.isEmpty()) {
                stack.set(ModDataComponentTypes.COMPOUND_TAG, (Object)emptyTag);
                return InteractionResult.FAIL;
            }
            tag.put("augments", (Tag)augmentsTag);
        }
        tag.putString("machine_type", block.getDescriptionId());
        stack.set(ModDataComponentTypes.COMPOUND_TAG, (Object)tag);
        context.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.ifeu.configuration_tool.copy").withStyle(ChatFormatting.GOLD), true);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult applyConfig(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos clickedBlockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(clickedBlockPos);
        Block block = blockState.getBlock();
        ItemStack stack = context.getItemInHand();
        CompoundTag itemTag = (CompoundTag)stack.get(ModDataComponentTypes.COMPOUND_TAG);
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        AtomicReference invFacings = new AtomicReference(new HashMap());
        AtomicReference fluidFacings = new AtomicReference(new HashMap());
        ArrayList<Map<String, Float>> augmentsTag = new ArrayList<Map<String, Float>>();
        AtomicReference<NonNullList> augItem = new AtomicReference<NonNullList>(NonNullList.create());
        if (itemTag != null) {
            boolean hasFluidConfig = itemTag.contains("fluidFacingModes");
            boolean hasInvConfig = itemTag.contains("invFacingModes");
            boolean hasAugments = itemTag.contains("augments");
            if (!itemTag.contains("machine_type")) {
                return InteractionResult.FAIL;
            }
            if (block.getDescriptionId().equals(itemTag.getString("machine_type"))) {
                String face;
                HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode> map;
                Iterator iterator;
                CompoundTag facingMode;
                CompoundTag facingModes;
                if (hasInvConfig) {
                    facingModes = itemTag.getCompound("invFacingModes");
                    for (String key : facingModes.getAllKeys()) {
                        facingMode = facingModes.getCompound(key);
                        iterator = facingMode.getAllKeys().iterator();
                        if (key.equals("augments")) continue;
                        map = new HashMap();
                        while (iterator.hasNext()) {
                            face = (String)iterator.next();
                            map.put(FacingUtil.Sideness.valueOf((String)face), IFacingComponent.FaceMode.valueOf((String)facingMode.getString(face)));
                        }
                        invFacings.get().put(key, map);
                    }
                }
                if (hasFluidConfig) {
                    facingModes = itemTag.getCompound("fluidFacingModes");
                    for (String key : facingModes.getAllKeys()) {
                        facingMode = facingModes.getCompound(key);
                        iterator = facingMode.getAllKeys().iterator();
                        map = new HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode>();
                        while (iterator.hasNext()) {
                            face = (String)iterator.next();
                            map.put(FacingUtil.Sideness.valueOf((String)face), IFacingComponent.FaceMode.valueOf((String)facingMode.getString(face)));
                        }
                        fluidFacings.get().put(key, map);
                    }
                }
                if (hasAugments) {
                    CompoundTag tempAugmentsTag = itemTag.getCompound("augments");
                    int index = tempAugmentsTag.getAllKeys().size();
                    for (int i = 0; i < index; ++i) {
                        HashMap<String, Float> map2 = new HashMap<String, Float>();
                        String key = "augment" + i;
                        CompoundTag tag = tempAugmentsTag.getCompound(key);
                        map2.put(tag.getString("string"), Float.valueOf(tag.getFloat("float")));
                        augmentsTag.add(map2);
                        augItem.get().add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("item_id")))));
                    }
                }
                if (blockState.hasBlockEntity()) {
                    ActiveTile activeTile;
                    BlockEntity blockEntity = level.getBlockEntity(clickedBlockPos);
                    if (blockEntity instanceof ActiveTile && !(activeTile = (ActiveTile)blockEntity).isClient()) {
                        if (activeTile.getMultiInventoryComponent() != null && hasInvConfig) {
                            activeTile.getMultiInventoryComponent().getInventoryHandlers().forEach(component -> {
                                if (component instanceof SidedInventoryComponent) {
                                    SidedInventoryComponent side = (SidedInventoryComponent)component;
                                    if (side.getName().equals("augments")) {
                                        return;
                                    }
                                    side.getFacingModes().clear();
                                    side.getFacingModes().putAll((Map)((HashMap)invFacings.get()).get(side.getName()));
                                }
                            });
                        }
                        if (activeTile.getMultiTankComponent() != null && hasFluidConfig) {
                            activeTile.getMultiTankComponent().getTanks().forEach(component -> {
                                if (component instanceof SidedFluidTankComponent) {
                                    SidedFluidTankComponent side = (SidedFluidTankComponent)component;
                                    side.getFacingModes().clear();
                                    side.getFacingModes().putAll((Map)((HashMap)fluidFacings.get()).get(side.getName()));
                                }
                            });
                        }
                        activeTile.markForUpdate();
                        activeTile.markComponentDirty();
                    }
                    if (hasAugments && blockEntity instanceof MachineTile) {
                        MachineTile machineTile = (MachineTile)blockEntity;
                        Inventory inventory = player.getInventory();
                        this.insertAugment((NonNullList<Item>)augItem.get(), augmentsTag, player, inventory, machineTile, SpeedAddonItem.class);
                        this.insertAugment((NonNullList<Item>)augItem.get(), augmentsTag, player, inventory, machineTile, RangeAddonItem.class);
                        this.insertAugment((NonNullList<Item>)augItem.get(), augmentsTag, player, inventory, machineTile, EfficiencyAddonItem.class);
                        this.insertAugment((NonNullList<Item>)augItem.get(), augmentsTag, player, inventory, machineTile, ProcessingAddonItem.class);
                        this.insertAugment((NonNullList<Item>)augItem.get(), augmentsTag, player, inventory, machineTile, ModThreadAddonItem.class);
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.configuration_tool.paste").withStyle(ChatFormatting.GOLD), true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.configuration_tool.different_type").withStyle(ChatFormatting.RED), true);
        }
        return InteractionResult.PASS;
    }

    private void insertAugment(NonNullList<Item> augItems, ArrayList<Map<String, Float>> augmentsTag, Player player, Inventory playerInventory, MachineTile<?> machineTile, Class<?> clazz) {
        for (int i = 0; i < augItems.size(); ++i) {
            if (!clazz.isAssignableFrom(((Item)augItems.get(i)).getClass())) continue;
            Item item = (Item)augItems.get(i);
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!(item instanceof IFEUAddonItem)) {
                stack.set((Supplier)AugmentWrapper.ATTACHMENT, augmentsTag.get(i));
            }
            if (playerInventory.findSlotMatchingItem(stack) != -1 && InventoryComponentHelper.canInsertAugment(machineTile, stack)) {
                int index = playerInventory.findSlotMatchingItem(stack);
                playerInventory.getItem(index).setCount(playerInventory.getItem(index).getCount() - 1);
                InventoryComponentHelper.insertAugment(machineTile, stack);
                continue;
            }
            player.sendSystemMessage((Component)Component.translatable((String)"message.ifeu.configuration_tool.missing_augment").withStyle(ChatFormatting.RED));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide()) {
            BlockHitResult blockHitResult = (BlockHitResult)player.pick(player.blockInteractionRange(), 0.0f, false);
            if (player.isShiftKeyDown() && level.getBlockState(blockHitResult.getBlockPos()).isAir()) {
                player.getMainHandItem().set(ModDataComponentTypes.COMPOUND_TAG, (Object)new CompoundTag());
                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.clear_configuration").withStyle(ChatFormatting.GREEN), true);
                return InteractionResultHolder.success((Object)player.getMainHandItem());
            }
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
        TooltipHelper.addTooltipWhileKeyDown(TooltipHelper.KeyType.SHIFT, tooltips, () -> {
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 0);
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GOLD, 1);
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 2);
        });
        CompoundTag tag = (CompoundTag)stack.get(ModDataComponentTypes.COMPOUND_TAG);
        if (tag == null || !tag.contains("machine_type")) {
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 3, new Object[]{"null"});
        } else {
            String s = tag.getString("machine_type");
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.AQUA, 3, new Object[]{Component.translatable((String)s)});
        }
    }
}

