/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.yxiao233.ifeu.common.block.entity.FluidTransferEntity;
import net.yxiao233.ifeu.common.registry.ModDataComponentTypes;
import net.yxiao233.ifeu.common.utils.IntArrayBlockPosUtil;
import net.yxiao233.ifeu.common.utils.TooltipHelper;

public class ConnectToolItem
extends Item {
    public ConnectToolItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide()) {
            Player player = context.getPlayer();
            BlockPos currentBlockPos = context.getClickedPos();
            if (player == null) {
                return super.useOn(context);
            }
            ItemStack item = player.getMainHandItem();
            CompoundTag tag = new CompoundTag();
            CompoundTag emptyTag = new CompoundTag();
            CompoundTag itemTag = (CompoundTag)item.get(ModDataComponentTypes.COMPOUND_TAG);
            if (level.getBlockEntity(currentBlockPos) instanceof FluidTransferEntity) {
                this.addPos1ToTag(item, tag, player, currentBlockPos);
                this.addPos2ToTag(item, tag, player, currentBlockPos);
                if (tag.contains("pos2")) {
                    BlockPos blockPos2;
                    BlockPos blockPos1 = tag.contains("pos1") ? this.getBlockPos(tag, "pos1") : this.getBlockPos(item, "pos1");
                    if (blockPos1.equals((Object)(blockPos2 = this.getBlockPos(tag, "pos2")))) {
                        tag = emptyTag;
                        player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.same_pos").withStyle(ChatFormatting.RED), true);
                    } else {
                        FluidTransferEntity entity1 = this.getFluidTransferEntity(level, blockPos1);
                        FluidTransferEntity entity2 = this.getFluidTransferEntity(level, blockPos2);
                        if (entity1 != null && entity2 != null) {
                            if (ConnectToolItem.getDistance(blockPos1, blockPos2) <= (double)ConnectToolItem.getCanConnectDistance(entity1, entity2)) {
                                entity1.hasConnect = true;
                                entity2.hasConnect = true;
                                entity1.connectBlockPos = blockPos2;
                                entity2.connectBlockPos = blockPos1;
                                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.connect_success").withStyle(ChatFormatting.GREEN), true);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.beyond_distance").withStyle(ChatFormatting.RED), true);
                            }
                        }
                    }
                }
                if (itemTag != null) {
                    if (!tag.contains("pos1") && itemTag.contains("pos1")) {
                        BlockPos pos1 = this.getBlockPos(item, "pos1");
                        tag.putIntArray("pos1", IntArrayBlockPosUtil.BlockPosToIntArray(pos1));
                    }
                    if (!tag.contains("pos2") && itemTag.contains("pos2")) {
                        BlockPos pos2 = this.getBlockPos(item, "pos2");
                        tag.putIntArray("pos2", IntArrayBlockPosUtil.BlockPosToIntArray(pos2));
                    }
                }
                item.set(ModDataComponentTypes.COMPOUND_TAG, (Object)tag);
            } else if (player.isShiftKeyDown()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.clear_configuration").withStyle(ChatFormatting.GREEN), true);
                item.set(ModDataComponentTypes.COMPOUND_TAG, (Object)emptyTag);
            }
        }
        return super.useOn(context);
    }

    private BlockPos getBlockPos(ItemStack stack, String posId) {
        CompoundTag tag = (CompoundTag)stack.get(ModDataComponentTypes.COMPOUND_TAG);
        return this.getBlockPos(tag, posId);
    }

    private BlockPos getBlockPos(CompoundTag tag, String posId) {
        if (tag == null) {
            return null;
        }
        if (tag.contains(posId)) {
            int[] temp = tag.getIntArray(posId);
            return new BlockPos((Vec3i)IntArrayBlockPosUtil.intArrayToBlockPos(temp));
        }
        return null;
    }

    private void addPos1ToTag(ItemStack item, CompoundTag tag, Player player, BlockPos pos1) {
        if (!player.isShiftKeyDown()) {
            if (item.has(ModDataComponentTypes.COMPOUND_TAG) && !((CompoundTag)item.get(ModDataComponentTypes.COMPOUND_TAG)).contains("pos1")) {
                tag.putIntArray("pos1", IntArrayBlockPosUtil.BlockPosToIntArray(pos1));
                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.pos1", (Object[])new Object[]{pos1.getX(), pos1.getY(), pos1.getZ()}).withStyle(ChatFormatting.GOLD), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.has_pos1").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    private void addPos2ToTag(ItemStack item, CompoundTag tag, Player player, BlockPos pos2) {
        if (player.isShiftKeyDown()) {
            if (item.has(ModDataComponentTypes.COMPOUND_TAG) && ((CompoundTag)item.get(ModDataComponentTypes.COMPOUND_TAG)).contains("pos1")) {
                tag.putIntArray("pos2", IntArrayBlockPosUtil.BlockPosToIntArray(pos2));
                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.pos2", (Object[])new Object[]{pos2.getX(), pos2.getY(), pos2.getZ()}).withStyle(ChatFormatting.GOLD), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.ifeu.connect_tool.no_pos1").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    private FluidTransferEntity getFluidTransferEntity(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof FluidTransferEntity) {
            FluidTransferEntity entity = (FluidTransferEntity)blockEntity;
            return entity;
        }
        return null;
    }

    public static double getDistance(BlockPos pos1, BlockPos pos2) {
        int x1 = pos1.getX();
        int y1 = pos1.getY();
        int z1 = pos1.getZ();
        int x2 = pos2.getX();
        int y2 = pos2.getY();
        int z2 = pos2.getZ();
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }

    public static int getCanConnectDistance(FluidTransferEntity entity1, FluidTransferEntity entity2) {
        return Math.max(entity1.maxConnectionDistance, entity2.maxConnectionDistance);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
        CompoundTag tag = (CompoundTag)stack.get(ModDataComponentTypes.COMPOUND_TAG);
        TooltipHelper.addTooltipWhileKeyDown(TooltipHelper.KeyType.SHIFT, tooltips, () -> {
            int[] temp;
            if (tag != null && tag.contains("pos1")) {
                temp = tag.getIntArray("pos1");
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 0, new Object[]{temp[0], temp[1], temp[2]});
            } else {
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 1);
            }
            if (tag != null && tag.contains("pos2")) {
                temp = tag.getIntArray("pos2");
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 2, new Object[]{temp[0], temp[1], temp[2]});
            } else {
                TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 3);
            }
        });
        TooltipHelper.addTooltipWhileKeyDown(TooltipHelper.KeyType.CONTROL, tooltips, () -> {
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 4);
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 5);
            TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 6);
        });
        TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.RED, 7);
    }
}

