/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.item;

import com.hrznstudio.titanium.block.tile.BasicTile;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.yxiao233.ifeu.common.registry.ModTags;
import net.yxiao233.ifeu.common.utils.TooltipHelper;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (!level.isClientSide() && player != null && player.isShiftKeyDown()) {
            BlockState blockState = null;
            Block block = null;
            Inventory inventory = player.getInventory();
            BasicTile entity = null;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BasicTile) {
                BasicTile tile = (BasicTile)blockEntity;
                blockState = tile.getBlockState();
                block = blockState.getBlock();
                entity = tile;
            } else if (level.getBlockState(pos).getTags().toList().contains(ModTags.Blocks.WRENCH_PICKUP)) {
                blockState = level.getBlockState(pos);
                block = blockState.getBlock();
                if (blockState.hasBlockEntity()) {
                    entity = level.getBlockEntity(pos);
                }
            }
            if (block == null) {
                return InteractionResult.FAIL;
            }
            if (block.canEntityDestroy(blockState, (BlockGetter)level, pos, (Entity)player)) {
                level.destroyBlock(pos, false);
                this.addToInventory(level, blockState, pos, (BlockEntity)entity, player, player.getUseItem(), inventory);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    public void addToInventory(Level level, BlockState state, BlockPos pos, BlockEntity entity, Player player, ItemStack tool, Inventory playerInventory) {
        List list = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)entity, (Entity)player, (ItemStack)tool);
        list.forEach(itemStack -> {
            if (playerInventory.getFreeSlot() != -1 || playerInventory.contains(itemStack)) {
                playerInventory.add(itemStack);
            } else {
                this.dropContents(level, pos, (ItemStack)itemStack);
            }
        });
    }

    public void dropContents(Level level, BlockPos pos, ItemStack stack) {
        double d0 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d1 = (double)pos.getX() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
        double d2 = (double)pos.getY() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pos.getZ() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
        ItemEntity item = new ItemEntity(level, d1, d2, d3, stack);
        level.addFreshEntity((Entity)item);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
        TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GOLD, 0);
        TooltipHelper.addTooltipWhileKeyDown(TooltipHelper.KeyType.SHIFT, tooltips, () -> TooltipHelper.addTooltip(tooltips, stack, ChatFormatting.GREEN, 1));
    }
}

