/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.yxiao233.ifeu.api.recipe.FluidGeneratorSerializableRecipe;
import net.yxiao233.ifeu.common.recipe.DragonStarGeneratorRecipe;
import net.yxiao233.ifeu.common.registry.ModRecipes;

public class DragonGeneratorRecipe
extends FluidGeneratorSerializableRecipe {
    public static final MapCodec<DragonGeneratorRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)FluidStack.CODEC.fieldOf("input").forGetter(o -> o.inputFluid), (App)Codec.INT.fieldOf("progressTime").forGetter(o -> o.progressTime), (App)Codec.INT.fieldOf("powerPerTick").forGetter(o -> o.powerPerTick)).apply((Applicative)in, DragonGeneratorRecipe::new));

    public DragonGeneratorRecipe(FluidStack inputFluid, int progressTime, int powerPerTick) {
        super(inputFluid, progressTime, powerPerTick);
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, DragonStarGeneratorRecipe recipe) {
        ResourceLocation rl = DragonGeneratorRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)("dragon_generator/" + key));
    }

    @Override
    public boolean isOnlyForPreview() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return null;
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.DRAGON_GENERATOR_TYPE.get();
    }
}

