/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.yxiao233.ifeu.api.recipe.ItemGeneratorSerializableRecipe;
import net.yxiao233.ifeu.common.registry.ModRecipes;

public class DragonStarGeneratorRecipe
extends ItemGeneratorSerializableRecipe {
    public static final MapCodec<DragonStarGeneratorRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)ItemStack.CODEC.fieldOf("input").forGetter(o -> o.input), (App)Codec.INT.fieldOf("time").forGetter(o -> o.time), (App)Codec.INT.fieldOf("powerPerTick").forGetter(o -> o.powerPerTick)).apply((Applicative)in, DragonStarGeneratorRecipe::new));
    public ItemStack input;
    public int time;
    public int powerPerTick;

    public DragonStarGeneratorRecipe(ItemStack input, int progressTime, int powerPerTick) {
        super(input, progressTime, powerPerTick);
    }

    @Override
    public boolean isOnlyForPreview() {
        return true;
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, DragonStarGeneratorRecipe recipe) {
        ResourceLocation rl = DragonStarGeneratorRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)("dragon_star_generator/" + key));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.DRAGON_STAR_GENERATOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.DRAGON_STAR_GENERATOR_TYPE.get();
    }
}

