/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.yxiao233.ifeu.common.recipe.BlockRightClickRecipe;
import net.yxiao233.ifeu.common.registry.ModContents;
import net.yxiao233.ifeu.common.registry.ModRecipes;
import net.yxiao233.ifeu.common.structure.IFEUMultiBlockStructures;

public class StructureInfoRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<StructureInfoRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)IFEUMultiBlockStructures.CODEC.fieldOf("structure").forGetter(o -> o.structure)).apply((Applicative)in, StructureInfoRecipe::new));
    public IFEUMultiBlockStructures structure;

    public StructureInfoRecipe(IFEUMultiBlockStructures structure) {
        this.structure = structure;
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, BlockRightClickRecipe recipe) {
        ResourceLocation rl = StructureInfoRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)("structure_info/" + key));
    }

    public boolean matches(Player player, BlockHitResult hit, Level level) {
        return true;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModContents.BLUEPRINT.asItem());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.BLOCK_RIGHT_CLICK_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.BLOCK_RIGHT_CLICK_TYPE.get();
    }
}

