/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.registry;

import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.yxiao233.ifeu.common.registry.ModContents;
import net.yxiao233.ifeu.common.registry.ModTags;
import org.jetbrains.annotations.Nullable;

public enum ModTiers implements Tier
{
    DRAGON_STAR(5, 4096, 18.0f, 7.0f, 25, () -> Ingredient.of((ItemLike[])new ItemLike[]{ModContents.DRAGON_STAR}));

    private final int level;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private ModTiers(int pLevel, int pUses, float pSpeed, float pDamage, int pEnchantmentValue, Supplier<Ingredient> pRepairIngredient) {
        this.level = pLevel;
        this.uses = pUses;
        this.speed = pSpeed;
        this.damage = pDamage;
        this.enchantmentValue = pEnchantmentValue;
        Objects.requireNonNull(pRepairIngredient);
        this.repairIngredient = Suppliers.memoize(pRepairIngredient::get);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return ModTags.Blocks.NEEDS_DRAGON_STAR_TOOL;
    }

    public int getLevel() {
        return this.level;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    @Nullable
    public TagKey<Block> getTag() {
        return ModTiers.getTagFromVanillaTier(this);
    }

    public static TagKey<Block> getTagFromVanillaTier(ModTiers modTiers) {
        return switch (modTiers.ordinal()) {
            case 0 -> ModTags.Blocks.NEEDS_DRAGON_STAR_TOOL;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

