/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import com.hrznstudio.titanium.block.tile.MachineTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.yxiao233.ifeu.api.item.IFEUAddonItem;
import net.yxiao233.ifeu.api.item.IFEUAugmentTypes;

public class AugmentInventoryHelper {
    public static int getAugmentIndex(InventoryComponent<?> augmentInventory, IFEUAugmentTypes type) {
        for (int i = 0; i < augmentInventory.getSlots(); ++i) {
            IFEUAddonItem addonItem;
            Item item = augmentInventory.getStackInSlot(i).getItem();
            if (!(item instanceof IFEUAddonItem) || (addonItem = (IFEUAddonItem)item).getType() != type) continue;
            return i;
        }
        return -1;
    }

    public static int getAugmentIndex(MachineTile<?> tile, IFEUAugmentTypes type) {
        return AugmentInventoryHelper.getAugmentIndex(tile.getAugmentInventory(), type);
    }

    public static int getAugmentIndex(InventoryComponent<?> augmentInventory, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IFEUAddonItem) {
            IFEUAddonItem addonItem1 = (IFEUAddonItem)item;
            return AugmentInventoryHelper.getAugmentIndex(augmentInventory, addonItem1.getType());
        }
        return -1;
    }

    public static int getAugmentIndex(MachineTile<?> tile, ItemStack stack) {
        return AugmentInventoryHelper.getAugmentIndex(tile.getAugmentInventory(), stack);
    }

    public static int getAugmentIndex(InventoryComponent<?> augmentInventory, Item item) {
        return AugmentInventoryHelper.getAugmentIndex(augmentInventory, item.getDefaultInstance());
    }

    public static int getAugmentIndex(MachineTile<?> tile, Item item) {
        return AugmentInventoryHelper.getAugmentIndex(tile.getAugmentInventory(), item);
    }

    public static boolean contains(InventoryComponent<?> augmentInventory, ItemStack stack) {
        return AugmentInventoryHelper.getAugmentIndex(augmentInventory, stack) != -1;
    }

    public static boolean contains(MachineTile<?> tile, ItemStack stack) {
        return AugmentInventoryHelper.contains(tile.getAugmentInventory(), stack);
    }

    public static boolean canAccept(InventoryComponent<?> augmentInventory, ItemStack stack) {
        return !AugmentInventoryHelper.contains(augmentInventory, stack);
    }

    public static boolean canAccept(MachineTile<?> tile, ItemStack stack) {
        return AugmentInventoryHelper.canAccept(tile.getAugmentInventory(), stack);
    }

    public static int getAugmentTier(InventoryComponent<?> augmentInventory, IFEUAugmentTypes type) {
        int index = AugmentInventoryHelper.getAugmentIndex(augmentInventory, type);
        return index == -1 ? 0 : ((IFEUAddonItem)augmentInventory.getStackInSlot(index).getItem()).getTier();
    }

    public static int getAugmentTier(MachineTile<?> tile, IFEUAugmentTypes type) {
        return AugmentInventoryHelper.getAugmentTier(tile.getAugmentInventory(), type);
    }
}

