/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockBoxHelper {
    private static final Gson Gson = new Gson();
    private int size;
    private JsonArray jsonArray;

    public BlockBoxHelper(String fileName) {
        try {
            InputStream is = BlockBoxHelper.class.getResourceAsStream("/assets/ifeu/models/block/" + fileName + ".json");
            if (is == null) {
                throw new IOException("File not found");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            JsonObject jsonObject = (JsonObject)Gson.fromJson((Reader)reader, JsonObject.class);
            this.jsonArray = jsonObject.getAsJsonArray("elements");
            this.size = this.jsonArray.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public VoxelShape getVoxelShapes() {
        VoxelShape[] shapes = new VoxelShape[this.size];
        for (int i = 0; i < this.jsonArray.size(); ++i) {
            String from = this.jsonArray.get(i).getAsJsonObject().get("from").toString();
            String to = this.jsonArray.get(i).getAsJsonObject().get("to").toString();
            int[] froms = this.getXYZ(from);
            int[] tos = this.getXYZ(to);
            shapes[i] = Block.box((double)froms[0], (double)froms[1], (double)froms[2], (double)tos[0], (double)tos[1], (double)tos[2]);
        }
        return Shapes.or((VoxelShape)shapes[0], (VoxelShape[])shapes);
    }

    private int[] getXYZ(String FROMorTO) {
        int[] xyz = new int[3];
        int leftBound = FROMorTO.indexOf("[");
        int rightBound = FROMorTO.indexOf("]");
        int firstIndex = FROMorTO.indexOf(",");
        int lastIndex = FROMorTO.lastIndexOf(",");
        xyz[0] = Integer.valueOf(FROMorTO.substring(leftBound + 1, firstIndex));
        xyz[1] = Integer.valueOf(FROMorTO.substring(firstIndex + 1, lastIndex));
        xyz[2] = Integer.valueOf(FROMorTO.substring(lastIndex + 1, rightBound));
        return xyz;
    }
}

