/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.level.ServerLevel;
import org.popcraft.chunky.ChunkyNeoForge;
import org.popcraft.chunky.integration.Integration;
import org.popcraft.chunky.platform.Config;
import org.popcraft.chunky.platform.NeoForgePlayer;
import org.popcraft.chunky.platform.NeoForgeSender;
import org.popcraft.chunky.platform.NeoForgeWorld;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.Server;
import org.popcraft.chunky.platform.World;

public class NeoForgeServer
implements Server {
    private final ChunkyNeoForge plugin;
    private final MinecraftServer server;

    public NeoForgeServer(ChunkyNeoForge plugin, MinecraftServer server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Override
    public Map<String, Integration> getIntegrations() {
        return Map.of();
    }

    @Override
    public Optional<World> getWorld(String name) {
        return Optional.ofNullable(ResourceLocation.tryParse((String)name)).map(resourceLocation -> this.server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)resourceLocation))).or(() -> {
            for (ServerLevel level : this.server.getAllLevels()) {
                if (!name.equals(level.dimension().location().getPath())) continue;
                return Optional.of(level);
            }
            return Optional.empty();
        }).map(NeoForgeWorld::new);
    }

    @Override
    public List<World> getWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        this.server.getAllLevels().forEach(world -> worlds.add(new NeoForgeWorld((ServerLevel)world)));
        return worlds;
    }

    @Override
    public int getMaxWorldSize() {
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer instanceof ServerInterface) {
            ServerInterface serverInterface = (ServerInterface)minecraftServer;
            return serverInterface.getProperties().maxWorldSize;
        }
        return this.server.getAbsoluteMaxWorldSize();
    }

    @Override
    public Sender getConsole() {
        return new NeoForgeSender(this.server.createCommandSourceStack());
    }

    @Override
    public Collection<Player> getPlayers() {
        return this.server.getPlayerList().getPlayers().stream().map(NeoForgePlayer::new).collect(Collectors.toList());
    }

    @Override
    public Optional<Player> getPlayer(String name) {
        return Optional.ofNullable(this.server.getPlayerList().getPlayerByName(name)).map(NeoForgePlayer::new);
    }

    @Override
    public Config getConfig() {
        return this.plugin.getChunky().getConfig();
    }
}

