/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

public class FissionReactorCache
extends MultiblockCache<FissionReactorMultiblockData> {
    private double reactorDamage;
    private double rateLimit = -1.0;
    private double burnRemaining;
    private double partialWaste;
    private boolean active;
    private boolean forceDisable;

    private double getRateLimit() {
        if (this.rateLimit == -1.0) {
            return MekanismGeneratorsConfig.generators.defaultBurnRate.get();
        }
        return this.rateLimit;
    }

    public void merge(MultiblockCache<FissionReactorMultiblockData> mergeCache, MultiblockCache.RejectContents rejectContents) {
        super.merge(mergeCache, rejectContents);
        this.reactorDamage = Math.max(this.reactorDamage, ((FissionReactorCache)mergeCache).reactorDamage);
        this.rateLimit = Math.max(this.rateLimit, ((FissionReactorCache)mergeCache).rateLimit);
        this.burnRemaining += ((FissionReactorCache)mergeCache).burnRemaining;
        this.partialWaste += ((FissionReactorCache)mergeCache).partialWaste;
        this.active |= ((FissionReactorCache)mergeCache).active;
        this.forceDisable |= ((FissionReactorCache)mergeCache).forceDisable;
    }

    public void apply(HolderLookup.Provider provider, FissionReactorMultiblockData data) {
        super.apply(provider, (MultiblockData)data);
        data.reactorDamage = this.reactorDamage;
        data.rateLimit = Mth.clamp((double)this.getRateLimit(), (double)0.0, (double)data.getMaxBurnRate());
        data.burnRemaining = this.burnRemaining;
        data.partialWaste = this.partialWaste;
        data.setForceDisable(this.forceDisable);
        data.setActive(this.active);
    }

    public void sync(FissionReactorMultiblockData data) {
        super.sync((MultiblockData)data);
        this.reactorDamage = data.reactorDamage;
        this.rateLimit = data.rateLimit;
        this.burnRemaining = data.burnRemaining;
        this.partialWaste = data.partialWaste;
        this.forceDisable = data.isForceDisabled();
        this.active = data.isActive();
    }

    public void load(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.load(provider, nbtTags);
        this.reactorDamage = nbtTags.getDouble("reactor_damage");
        NBTUtils.setDoubleIfPresent((CompoundTag)nbtTags, (String)"injection_rate", value -> {
            this.rateLimit = value;
        });
        this.burnRemaining = nbtTags.getDouble("burn_time");
        this.partialWaste = nbtTags.getDouble("partial_waste");
        this.forceDisable = nbtTags.getBoolean("disabled");
        this.active = nbtTags.getBoolean("active");
    }

    public void save(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.save(provider, nbtTags);
        nbtTags.putDouble("reactor_damage", this.reactorDamage);
        nbtTags.putDouble("injection_rate", this.getRateLimit());
        nbtTags.putDouble("burn_time", this.burnRemaining);
        nbtTags.putDouble("partial_waste", this.partialWaste);
        nbtTags.putBoolean("disabled", this.forceDisable);
        nbtTags.putBoolean("active", this.active);
    }
}

