/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.attribute.ChemicalFuel;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.chemical.VariableCapacityChemicalTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityGasGenerator
extends TileEntityGenerator {
    public static final Predicate<ChemicalStack> HAS_FUEL = chemical -> chemical.getData(IMekanismDataMapTypes.INSTANCE.chemicalFuel()) != null || chemical.hasLegacy(ChemicalAttributes.Fuel.class);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getFuel", "getFuelCapacity", "getFuelNeeded", "getFuelFilledPercentage"}, docPlaceholder="fuel tank")
    public FuelTank fuelTank;
    private long burnTicks;
    private int maxBurnTicks;
    private long generationRate = 0L;
    private double gasUsedLastTick;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel item slot")
    ChemicalInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;

    public TileEntityGasGenerator(BlockPos pos, BlockState state) {
        super((Holder<Block>)GeneratorsBlocks.GAS_BURNING_GENERATOR, pos, state, ChemicalUtil::hydrogenEnergyPerTick);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide((Supplier)this.facingSupplier);
        this.fuelTank = new FuelTank(listener);
        builder.addTank((IChemicalTank)this.fuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier);
        this.fuelSlot = ChemicalInventorySlot.fill((IChemicalTank)this.fuelTank, (IContentsListener)listener, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        this.fuelSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillTank();
        if (!this.fuelTank.isEmpty() && this.canFunction() && this.getEnergyContainer().insert(this.generationRate, Action.SIMULATE, AutomationType.INTERNAL) == 0L) {
            ChemicalFuel fuel;
            this.setActive(true);
            if (!this.fuelTank.isEmpty() && (fuel = this.fuelTank.getFuel()) != null) {
                this.maxBurnTicks = Math.max(1, fuel.burnTicks());
                this.generationRate = fuel.energyPerTick();
            }
            long toUse = this.getToUse();
            long toUseGeneration = MathUtils.multiplyClamped((long)this.generationRate, (long)toUse);
            this.updateMaxOutputRaw(Math.max(ChemicalUtil.hydrogenEnergyPerTick(), toUseGeneration));
            long total = this.burnTicks + this.fuelTank.getStored() * (long)this.maxBurnTicks;
            total -= toUse;
            this.getEnergyContainer().insert(toUseGeneration, Action.EXECUTE, AutomationType.INTERNAL);
            if (!this.fuelTank.isEmpty()) {
                this.fuelTank.setStack(this.fuelTank.getStack().copyWithAmount(total / (long)this.maxBurnTicks));
            }
            this.burnTicks = total % (long)this.maxBurnTicks;
            this.gasUsedLastTick = (double)toUse / (double)this.maxBurnTicks;
        } else {
            if (this.fuelTank.isEmpty() && this.burnTicks == 0L) {
                this.reset();
            }
            this.gasUsedLastTick = 0.0;
            this.setActive(false);
        }
        return sendUpdatePacket;
    }

    private void reset() {
        this.burnTicks = 0L;
        this.maxBurnTicks = 0;
        this.generationRate = 0L;
        this.updateMaxOutputRaw(ChemicalUtil.hydrogenEnergyPerTick());
    }

    private long getToUse() {
        if (this.generationRate == 0L || this.fuelTank.isEmpty()) {
            return 0L;
        }
        long max = (long)Math.ceil(256.0 * ((double)this.fuelTank.getStored() / (double)this.fuelTank.getCapacity()));
        max = Math.min((long)this.maxBurnTicks * this.fuelTank.getStored() + this.burnTicks, max);
        max = Math.min(MathUtils.clampToLong((double)((double)this.getEnergyContainer().getNeeded() / (double)this.generationRate)), max);
        return max;
    }

    public long getGenerationRate() {
        return this.generationRate;
    }

    @ComputerMethod(nameOverride="getBurnRate")
    public double getUsed() {
        return (double)Math.round(this.gasUsedLastTick * 100.0) / 100.0;
    }

    public int getMaxBurnTicks() {
        return this.maxBurnTicks;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableLong.create(this::getGenerationRate, value -> {
            this.generationRate = value;
        }));
        container.track(this.syncableMaxOutput());
        container.track((ISyncableData)SyncableDouble.create(this::getUsed, value -> {
            this.gasUsedLastTick = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getMaxBurnTicks, value -> {
            this.maxBurnTicks = value;
        }));
    }

    @Override
    long getProductionRate() {
        return MathUtils.clampToLong((double)((double)this.getGenerationRate() * this.getUsed() * (double)this.getMaxBurnTicks()));
    }

    public class FuelTank
    extends VariableCapacityChemicalTank {
        protected FuelTank(IContentsListener listener) {
            super((LongSupplier)MekanismGeneratorsConfig.generators.gbgTankCapacity, ConstantPredicates.notExternal(), ConstantPredicates.alwaysTrueBi(), HAS_FUEL, null, listener);
        }

        public void setStack(@NotNull ChemicalStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStack(stack);
            this.recheckOutput(stack, wasEmpty);
        }

        public void setStackUnchecked(@NotNull ChemicalStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStackUnchecked(stack);
            this.recheckOutput(stack, wasEmpty);
        }

        private void recheckOutput(@NotNull ChemicalStack stack, boolean wasEmpty) {
            ChemicalFuel fuel;
            if (wasEmpty && !stack.isEmpty() && (fuel = this.getFuel()) != null) {
                TileEntityGasGenerator.this.updateMaxOutputRaw(fuel.energyPerTick());
            }
        }

        @Nullable
        public ChemicalFuel getFuel() {
            ChemicalAttributes.Fuel legacyFuel;
            if (this.isEmpty()) {
                return null;
            }
            ChemicalStack stack = this.getStack();
            ChemicalFuel fuel = (ChemicalFuel)stack.getData(IMekanismDataMapTypes.INSTANCE.chemicalFuel());
            if (fuel == null && (legacyFuel = (ChemicalAttributes.Fuel)stack.getLegacy(ChemicalAttributes.Fuel.class)) != null) {
                return legacyFuel.asModern();
            }
            return fuel;
        }
    }
}

