/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;

public enum TechLevel implements StringRepresentable
{
    DRACONIUM(0, "draconium", ChatFormatting.WHITE, Rarity.COMMON, 3),
    WYVERN(1, "wyvern", ChatFormatting.BLUE, Rarity.UNCOMMON, 32),
    DRACONIC(2, "draconic", ChatFormatting.GOLD, Rarity.RARE, 128),
    CHAOTIC(3, "chaotic", ChatFormatting.DARK_PURPLE, Rarity.EPIC, 512);

    public static final Codec<TechLevel> CODEC;
    public static final IntFunction<TechLevel> BY_ID;
    public static final StreamCodec<ByteBuf, TechLevel> STREAM_CODEC;
    public final int index;
    private final String name;
    private final ChatFormatting textColour;
    private Rarity rarity;
    private final int harvestLevel;
    private Tier itemTier;
    public static final TechLevel[] VALUES;
    public static final TechLevel[] TOOL_LEVELS;

    private TechLevel(int index, String name, ChatFormatting colour, Rarity rarity, int harvestLevel) {
        this.index = index;
        this.name = name;
        this.textColour = colour;
        this.rarity = rarity;
        this.harvestLevel = harvestLevel;
    }

    public ChatFormatting getTextColour() {
        return this.textColour;
    }

    public Component getDisplayName() {
        return Component.translatable((String)("tech_level.draconicevolution." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public static TechLevel byIndex(int index) {
        return index >= 0 && index < VALUES.length ? VALUES[index] : DRACONIUM;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromValues(TechLevel::values);
        BY_ID = ByIdMap.continuous(e -> e.index, (Object[])TechLevel.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, e -> e.index);
        VALUES = new TechLevel[4];
        TOOL_LEVELS = new TechLevel[3];
        TechLevel[] techLevelArray = TechLevel.values();
        int n = techLevelArray.length;
        for (int i = 0; i < n; ++i) {
            TechLevel tier;
            TechLevel.VALUES[tier.index] = tier = techLevelArray[i];
            if (tier == DRACONIUM) continue;
            TechLevel.TOOL_LEVELS[tier.index - 1] = tier;
        }
    }
}

