/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ManagedResource
extends AbstractManagedData<ResourceLocation> {
    private ResourceLocation value;
    protected Function<ResourceLocation, ResourceLocation> validator = null;

    public ManagedResource(String name, @Nullable ResourceLocation defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedResource(String name, DataFlags ... flags) {
        this(name, (ResourceLocation)null, flags);
    }

    public ResourceLocation set(@Nullable ResourceLocation value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            ResourceLocation prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public ResourceLocation get() {
        return this.value;
    }

    public ManagedResource setValidator(Function<ResourceLocation, ResourceLocation> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeResourceLocation(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readResourceLocation() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(HolderLookup.Provider provider, CompoundTag compound) {
        if (this.value != null) {
            compound.putString(this.name, this.value.toString());
        }
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        this.value = compound.contains(this.name) ? ResourceLocation.parse((String)compound.getString(this.name)) : null;
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + String.valueOf(this.value) + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

